/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.Descriptor;
import edu.nps.moves.dis7.EntityType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;

public class MunitionDescriptor
extends Descriptor {
    protected EntityType munitionType = new EntityType();
    protected int warhead;
    protected int fuse;
    protected int quantity;
    protected int rate;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += this.munitionType.getMarshalledSize();
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 2;
        return marshalSize += 2;
    }

    public void setMunitionType(EntityType pMunitionType) {
        this.munitionType = pMunitionType;
    }

    public EntityType getMunitionType() {
        return this.munitionType;
    }

    public void setWarhead(int pWarhead) {
        this.warhead = pWarhead;
    }

    public int getWarhead() {
        return this.warhead;
    }

    public void setFuse(int pFuse) {
        this.fuse = pFuse;
    }

    public int getFuse() {
        return this.fuse;
    }

    public void setQuantity(int pQuantity) {
        this.quantity = pQuantity;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setRate(int pRate) {
        this.rate = pRate;
    }

    public int getRate() {
        return this.rate;
    }

    public void marshal(DataOutputStream dos) {
        try {
            this.munitionType.marshal(dos);
            dos.writeShort((short)this.warhead);
            dos.writeShort((short)this.fuse);
            dos.writeShort((short)this.quantity);
            dos.writeShort((short)this.rate);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.munitionType.unmarshal(dis);
            this.warhead = dis.readUnsignedShort();
            this.fuse = dis.readUnsignedShort();
            this.quantity = dis.readUnsignedShort();
            this.rate = dis.readUnsignedShort();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        this.munitionType.marshal(buff);
        buff.putShort((short)this.warhead);
        buff.putShort((short)this.fuse);
        buff.putShort((short)this.quantity);
        buff.putShort((short)this.rate);
    }

    public void unmarshal(ByteBuffer buff) {
        this.munitionType.unmarshal(buff);
        this.warhead = buff.getShort() & 0xFFFF;
        this.fuse = buff.getShort() & 0xFFFF;
        this.quantity = buff.getShort() & 0xFFFF;
        this.rate = buff.getShort() & 0xFFFF;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof MunitionDescriptor)) {
            return false;
        }
        MunitionDescriptor rhs = (MunitionDescriptor)obj;
        if (!this.munitionType.equals(rhs.munitionType)) {
            ivarsEqual = false;
        }
        if (this.warhead != rhs.warhead) {
            ivarsEqual = false;
        }
        if (this.fuse != rhs.fuse) {
            ivarsEqual = false;
        }
        if (this.quantity != rhs.quantity) {
            ivarsEqual = false;
        }
        if (this.rate != rhs.rate) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

