/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.EntityType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class MunitionReload
implements Serializable {
    protected EntityType munitionType = new EntityType();
    protected long station;
    protected int standardQuantity;
    protected int maximumQuantity;
    protected long standardQuantityReloadTime;
    protected long maximumQuantityReloadTime;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += this.munitionType.getMarshalledSize();
        marshalSize += 4;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 4;
        return marshalSize += 4;
    }

    public void setMunitionType(EntityType pMunitionType) {
        this.munitionType = pMunitionType;
    }

    public EntityType getMunitionType() {
        return this.munitionType;
    }

    public void setStation(long pStation) {
        this.station = pStation;
    }

    public long getStation() {
        return this.station;
    }

    public void setStandardQuantity(int pStandardQuantity) {
        this.standardQuantity = pStandardQuantity;
    }

    public int getStandardQuantity() {
        return this.standardQuantity;
    }

    public void setMaximumQuantity(int pMaximumQuantity) {
        this.maximumQuantity = pMaximumQuantity;
    }

    public int getMaximumQuantity() {
        return this.maximumQuantity;
    }

    public void setStandardQuantityReloadTime(long pStandardQuantityReloadTime) {
        this.standardQuantityReloadTime = pStandardQuantityReloadTime;
    }

    public long getStandardQuantityReloadTime() {
        return this.standardQuantityReloadTime;
    }

    public void setMaximumQuantityReloadTime(long pMaximumQuantityReloadTime) {
        this.maximumQuantityReloadTime = pMaximumQuantityReloadTime;
    }

    public long getMaximumQuantityReloadTime() {
        return this.maximumQuantityReloadTime;
    }

    public void marshal(DataOutputStream dos) {
        try {
            this.munitionType.marshal(dos);
            dos.writeInt((int)this.station);
            dos.writeShort((short)this.standardQuantity);
            dos.writeShort((short)this.maximumQuantity);
            dos.writeInt((int)this.standardQuantityReloadTime);
            dos.writeInt((int)this.maximumQuantityReloadTime);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.munitionType.unmarshal(dis);
            this.station = dis.readInt();
            this.standardQuantity = dis.readUnsignedShort();
            this.maximumQuantity = dis.readUnsignedShort();
            this.standardQuantityReloadTime = dis.readInt();
            this.maximumQuantityReloadTime = dis.readInt();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        this.munitionType.marshal(buff);
        buff.putInt((int)this.station);
        buff.putShort((short)this.standardQuantity);
        buff.putShort((short)this.maximumQuantity);
        buff.putInt((int)this.standardQuantityReloadTime);
        buff.putInt((int)this.maximumQuantityReloadTime);
    }

    public void unmarshal(ByteBuffer buff) {
        this.munitionType.unmarshal(buff);
        this.station = buff.getInt();
        this.standardQuantity = buff.getShort() & 0xFFFF;
        this.maximumQuantity = buff.getShort() & 0xFFFF;
        this.standardQuantityReloadTime = buff.getInt();
        this.maximumQuantityReloadTime = buff.getInt();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof MunitionReload)) {
            return false;
        }
        MunitionReload rhs = (MunitionReload)obj;
        if (!this.munitionType.equals(rhs.munitionType)) {
            ivarsEqual = false;
        }
        if (this.station != rhs.station) {
            ivarsEqual = false;
        }
        if (this.standardQuantity != rhs.standardQuantity) {
            ivarsEqual = false;
        }
        if (this.maximumQuantity != rhs.maximumQuantity) {
            ivarsEqual = false;
        }
        if (this.standardQuantityReloadTime != rhs.standardQuantityReloadTime) {
            ivarsEqual = false;
        }
        if (this.maximumQuantityReloadTime != rhs.maximumQuantityReloadTime) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

