/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class RadioIdentifier
implements Serializable {
    protected int siteNumber;
    protected int applicationNumber;
    protected int referenceNumber;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 2;
        marshalSize += 2;
        return marshalSize += 2;
    }

    public void setSiteNumber(int pSiteNumber) {
        this.siteNumber = pSiteNumber;
    }

    public int getSiteNumber() {
        return this.siteNumber;
    }

    public void setApplicationNumber(int pApplicationNumber) {
        this.applicationNumber = pApplicationNumber;
    }

    public int getApplicationNumber() {
        return this.applicationNumber;
    }

    public void setReferenceNumber(int pReferenceNumber) {
        this.referenceNumber = pReferenceNumber;
    }

    public int getReferenceNumber() {
        return this.referenceNumber;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeShort((short)this.siteNumber);
            dos.writeShort((short)this.applicationNumber);
            dos.writeShort((short)this.referenceNumber);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.siteNumber = dis.readUnsignedShort();
            this.applicationNumber = dis.readUnsignedShort();
            this.referenceNumber = dis.readUnsignedShort();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.putShort((short)this.siteNumber);
        buff.putShort((short)this.applicationNumber);
        buff.putShort((short)this.referenceNumber);
    }

    public void unmarshal(ByteBuffer buff) {
        this.siteNumber = buff.getShort() & 0xFFFF;
        this.applicationNumber = buff.getShort() & 0xFFFF;
        this.referenceNumber = buff.getShort() & 0xFFFF;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof RadioIdentifier)) {
            return false;
        }
        RadioIdentifier rhs = (RadioIdentifier)obj;
        if (this.siteNumber != rhs.siteNumber) {
            ivarsEqual = false;
        }
        if (this.applicationNumber != rhs.applicationNumber) {
            ivarsEqual = false;
        }
        if (this.referenceNumber != rhs.referenceNumber) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

