/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.FourByteChunk;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class RecordQuerySpecification
implements Serializable {
    protected long numberOfRecords;
    protected List<FourByteChunk> records = new ArrayList<FourByteChunk>();

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 4;
        for (int idx = 0; idx < this.records.size(); ++idx) {
            FourByteChunk listElement = this.records.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public long getNumberOfRecords() {
        return this.records.size();
    }

    public void setNumberOfRecords(long pNumberOfRecords) {
        this.numberOfRecords = pNumberOfRecords;
    }

    public void setRecords(List<FourByteChunk> pRecords) {
        this.records = pRecords;
    }

    public List<FourByteChunk> getRecords() {
        return this.records;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeInt(this.records.size());
            for (int idx = 0; idx < this.records.size(); ++idx) {
                FourByteChunk aFourByteChunk = this.records.get(idx);
                aFourByteChunk.marshal(dos);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.numberOfRecords = dis.readInt();
            int idx = 0;
            while ((long)idx < this.numberOfRecords) {
                FourByteChunk anX = new FourByteChunk();
                anX.unmarshal(dis);
                this.records.add(anX);
                ++idx;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.putInt(this.records.size());
        for (int idx = 0; idx < this.records.size(); ++idx) {
            FourByteChunk aFourByteChunk = this.records.get(idx);
            aFourByteChunk.marshal(buff);
        }
    }

    public void unmarshal(ByteBuffer buff) {
        this.numberOfRecords = buff.getInt();
        int idx = 0;
        while ((long)idx < this.numberOfRecords) {
            FourByteChunk anX = new FourByteChunk();
            anX.unmarshal(buff);
            this.records.add(anX);
            ++idx;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof RecordQuerySpecification)) {
            return false;
        }
        RecordQuerySpecification rhs = (RecordQuerySpecification)obj;
        if (this.numberOfRecords != rhs.numberOfRecords) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.records.size(); ++idx) {
            if (this.records.get(idx).equals(rhs.records.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

