/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.RecordSpecificationElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class RecordSpecification
implements Serializable {
    protected long numberOfRecordSets;
    protected List<RecordSpecificationElement> recordSets = new ArrayList<RecordSpecificationElement>();

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 4;
        for (int idx = 0; idx < this.recordSets.size(); ++idx) {
            RecordSpecificationElement listElement = this.recordSets.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public long getNumberOfRecordSets() {
        return this.recordSets.size();
    }

    public void setNumberOfRecordSets(long pNumberOfRecordSets) {
        this.numberOfRecordSets = pNumberOfRecordSets;
    }

    public void setRecordSets(List<RecordSpecificationElement> pRecordSets) {
        this.recordSets = pRecordSets;
    }

    public List<RecordSpecificationElement> getRecordSets() {
        return this.recordSets;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeInt(this.recordSets.size());
            for (int idx = 0; idx < this.recordSets.size(); ++idx) {
                RecordSpecificationElement aRecordSpecificationElement = this.recordSets.get(idx);
                aRecordSpecificationElement.marshal(dos);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.numberOfRecordSets = dis.readInt();
            int idx = 0;
            while ((long)idx < this.numberOfRecordSets) {
                RecordSpecificationElement anX = new RecordSpecificationElement();
                anX.unmarshal(dis);
                this.recordSets.add(anX);
                ++idx;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.putInt(this.recordSets.size());
        for (int idx = 0; idx < this.recordSets.size(); ++idx) {
            RecordSpecificationElement aRecordSpecificationElement = this.recordSets.get(idx);
            aRecordSpecificationElement.marshal(buff);
        }
    }

    public void unmarshal(ByteBuffer buff) {
        this.numberOfRecordSets = buff.getInt();
        int idx = 0;
        while ((long)idx < this.numberOfRecordSets) {
            RecordSpecificationElement anX = new RecordSpecificationElement();
            anX.unmarshal(buff);
            this.recordSets.add(anX);
            ++idx;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof RecordSpecification)) {
            return false;
        }
        RecordSpecification rhs = (RecordSpecification)obj;
        if (this.numberOfRecordSets != rhs.numberOfRecordSets) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.recordSets.size(); ++idx) {
            if (this.recordSets.get(idx).equals(rhs.recordSets.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

