/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class RecordSpecificationElement
implements Serializable {
    protected long recordID;
    protected long recordSetSerialNumber;
    protected int recordLength;
    protected int recordCount;
    protected int recordValues;
    protected short pad4;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 2;
        return ++marshalSize;
    }

    public void setRecordID(long pRecordID) {
        this.recordID = pRecordID;
    }

    public long getRecordID() {
        return this.recordID;
    }

    public void setRecordSetSerialNumber(long pRecordSetSerialNumber) {
        this.recordSetSerialNumber = pRecordSetSerialNumber;
    }

    public long getRecordSetSerialNumber() {
        return this.recordSetSerialNumber;
    }

    public void setRecordLength(int pRecordLength) {
        this.recordLength = pRecordLength;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public void setRecordCount(int pRecordCount) {
        this.recordCount = pRecordCount;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void setRecordValues(int pRecordValues) {
        this.recordValues = pRecordValues;
    }

    public int getRecordValues() {
        return this.recordValues;
    }

    public void setPad4(short pPad4) {
        this.pad4 = pPad4;
    }

    public short getPad4() {
        return this.pad4;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeInt((int)this.recordID);
            dos.writeInt((int)this.recordSetSerialNumber);
            dos.writeShort((short)this.recordLength);
            dos.writeShort((short)this.recordCount);
            dos.writeShort((short)this.recordValues);
            dos.writeByte((byte)this.pad4);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.recordID = dis.readInt();
            this.recordSetSerialNumber = dis.readInt();
            this.recordLength = dis.readUnsignedShort();
            this.recordCount = dis.readUnsignedShort();
            this.recordValues = dis.readUnsignedShort();
            this.pad4 = (short)dis.readUnsignedByte();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.putInt((int)this.recordID);
        buff.putInt((int)this.recordSetSerialNumber);
        buff.putShort((short)this.recordLength);
        buff.putShort((short)this.recordCount);
        buff.putShort((short)this.recordValues);
        buff.put((byte)this.pad4);
    }

    public void unmarshal(ByteBuffer buff) {
        this.recordID = buff.getInt();
        this.recordSetSerialNumber = buff.getInt();
        this.recordLength = buff.getShort() & 0xFFFF;
        this.recordCount = buff.getShort() & 0xFFFF;
        this.recordValues = buff.getShort() & 0xFFFF;
        this.pad4 = (short)(buff.get() & 0xFF);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof RecordSpecificationElement)) {
            return false;
        }
        RecordSpecificationElement rhs = (RecordSpecificationElement)obj;
        if (this.recordID != rhs.recordID) {
            ivarsEqual = false;
        }
        if (this.recordSetSerialNumber != rhs.recordSetSerialNumber) {
            ivarsEqual = false;
        }
        if (this.recordLength != rhs.recordLength) {
            ivarsEqual = false;
        }
        if (this.recordCount != rhs.recordCount) {
            ivarsEqual = false;
        }
        if (this.recordValues != rhs.recordValues) {
            ivarsEqual = false;
        }
        if (this.pad4 != rhs.pad4) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

