/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.EntityID;
import edu.nps.moves.dis7.LogisticsFamilyPdu;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class RepairCompletePdu
extends LogisticsFamilyPdu
implements Serializable {
    protected EntityID receivingEntityID = new EntityID();
    protected EntityID repairingEntityID = new EntityID();
    protected int repair;
    protected short padding4 = 0;

    public RepairCompletePdu() {
        this.setPduType((short)9);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.receivingEntityID.getMarshalledSize();
        marshalSize += this.repairingEntityID.getMarshalledSize();
        marshalSize += 2;
        return marshalSize += 2;
    }

    public void setReceivingEntityID(EntityID pReceivingEntityID) {
        this.receivingEntityID = pReceivingEntityID;
    }

    public EntityID getReceivingEntityID() {
        return this.receivingEntityID;
    }

    public void setRepairingEntityID(EntityID pRepairingEntityID) {
        this.repairingEntityID = pRepairingEntityID;
    }

    public EntityID getRepairingEntityID() {
        return this.repairingEntityID;
    }

    public void setRepair(int pRepair) {
        this.repair = pRepair;
    }

    public int getRepair() {
        return this.repair;
    }

    public void setPadding4(short pPadding4) {
        this.padding4 = pPadding4;
    }

    public short getPadding4() {
        return this.padding4;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            this.receivingEntityID.marshal(dos);
            this.repairingEntityID.marshal(dos);
            dos.writeShort((short)this.repair);
            dos.writeShort(this.padding4);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            this.receivingEntityID.unmarshal(dis);
            this.repairingEntityID.unmarshal(dis);
            this.repair = dis.readUnsignedShort();
            this.padding4 = dis.readShort();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.receivingEntityID.marshal(buff);
        this.repairingEntityID.marshal(buff);
        buff.putShort((short)this.repair);
        buff.putShort(this.padding4);
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.receivingEntityID.unmarshal(buff);
        this.repairingEntityID.unmarshal(buff);
        this.repair = buff.getShort() & 0xFFFF;
        this.padding4 = buff.getShort();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof RepairCompletePdu)) {
            return false;
        }
        RepairCompletePdu rhs = (RepairCompletePdu)obj;
        if (!this.receivingEntityID.equals(rhs.receivingEntityID)) {
            ivarsEqual = false;
        }
        if (!this.repairingEntityID.equals(rhs.repairingEntityID)) {
            ivarsEqual = false;
        }
        if (this.repair != rhs.repair) {
            ivarsEqual = false;
        }
        if (this.padding4 != rhs.padding4) {
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

