/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.EntityType;
import edu.nps.moves.dis7.FourByteChunk;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class SilentEntitySystem
implements Serializable {
    protected int numberOfEntities;
    protected int numberOfAppearanceRecords;
    protected EntityType entityType = new EntityType();
    protected List<FourByteChunk> appearanceRecordList = new ArrayList<FourByteChunk>();

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += this.entityType.getMarshalledSize();
        for (int idx = 0; idx < this.appearanceRecordList.size(); ++idx) {
            FourByteChunk listElement = this.appearanceRecordList.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setNumberOfEntities(int pNumberOfEntities) {
        this.numberOfEntities = pNumberOfEntities;
    }

    public int getNumberOfEntities() {
        return this.numberOfEntities;
    }

    public int getNumberOfAppearanceRecords() {
        return this.appearanceRecordList.size();
    }

    public void setNumberOfAppearanceRecords(int pNumberOfAppearanceRecords) {
        this.numberOfAppearanceRecords = pNumberOfAppearanceRecords;
    }

    public void setEntityType(EntityType pEntityType) {
        this.entityType = pEntityType;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setAppearanceRecordList(List<FourByteChunk> pAppearanceRecordList) {
        this.appearanceRecordList = pAppearanceRecordList;
    }

    public List<FourByteChunk> getAppearanceRecordList() {
        return this.appearanceRecordList;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeShort((short)this.numberOfEntities);
            dos.writeShort((short)this.appearanceRecordList.size());
            this.entityType.marshal(dos);
            for (int idx = 0; idx < this.appearanceRecordList.size(); ++idx) {
                FourByteChunk aFourByteChunk = this.appearanceRecordList.get(idx);
                aFourByteChunk.marshal(dos);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.numberOfEntities = dis.readUnsignedShort();
            this.numberOfAppearanceRecords = dis.readUnsignedShort();
            this.entityType.unmarshal(dis);
            for (int idx = 0; idx < this.numberOfAppearanceRecords; ++idx) {
                FourByteChunk anX = new FourByteChunk();
                anX.unmarshal(dis);
                this.appearanceRecordList.add(anX);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.putShort((short)this.numberOfEntities);
        buff.putShort((short)this.appearanceRecordList.size());
        this.entityType.marshal(buff);
        for (int idx = 0; idx < this.appearanceRecordList.size(); ++idx) {
            FourByteChunk aFourByteChunk = this.appearanceRecordList.get(idx);
            aFourByteChunk.marshal(buff);
        }
    }

    public void unmarshal(ByteBuffer buff) {
        this.numberOfEntities = buff.getShort() & 0xFFFF;
        this.numberOfAppearanceRecords = buff.getShort() & 0xFFFF;
        this.entityType.unmarshal(buff);
        for (int idx = 0; idx < this.numberOfAppearanceRecords; ++idx) {
            FourByteChunk anX = new FourByteChunk();
            anX.unmarshal(buff);
            this.appearanceRecordList.add(anX);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof SilentEntitySystem)) {
            return false;
        }
        SilentEntitySystem rhs = (SilentEntitySystem)obj;
        if (this.numberOfEntities != rhs.numberOfEntities) {
            ivarsEqual = false;
        }
        if (this.numberOfAppearanceRecords != rhs.numberOfAppearanceRecords) {
            ivarsEqual = false;
        }
        if (!this.entityType.equals(rhs.entityType)) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.appearanceRecordList.size(); ++idx) {
            if (this.appearanceRecordList.get(idx).equals(rhs.appearanceRecordList.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

