/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.SimulationManagementPduHeader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class StandardVariableSpecification
implements Serializable {
    protected int numberOfStandardVariableRecords;
    protected List<SimulationManagementPduHeader> standardVariables = new ArrayList<SimulationManagementPduHeader>();

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 2;
        for (int idx = 0; idx < this.standardVariables.size(); ++idx) {
            SimulationManagementPduHeader listElement = this.standardVariables.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public int getNumberOfStandardVariableRecords() {
        return this.standardVariables.size();
    }

    public void setNumberOfStandardVariableRecords(int pNumberOfStandardVariableRecords) {
        this.numberOfStandardVariableRecords = pNumberOfStandardVariableRecords;
    }

    public void setStandardVariables(List<SimulationManagementPduHeader> pStandardVariables) {
        this.standardVariables = pStandardVariables;
    }

    public List<SimulationManagementPduHeader> getStandardVariables() {
        return this.standardVariables;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeShort((short)this.standardVariables.size());
            for (int idx = 0; idx < this.standardVariables.size(); ++idx) {
                SimulationManagementPduHeader aSimulationManagementPduHeader = this.standardVariables.get(idx);
                aSimulationManagementPduHeader.marshal(dos);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.numberOfStandardVariableRecords = dis.readUnsignedShort();
            for (int idx = 0; idx < this.numberOfStandardVariableRecords; ++idx) {
                SimulationManagementPduHeader anX = new SimulationManagementPduHeader();
                anX.unmarshal(dis);
                this.standardVariables.add(anX);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.putShort((short)this.standardVariables.size());
        for (int idx = 0; idx < this.standardVariables.size(); ++idx) {
            SimulationManagementPduHeader aSimulationManagementPduHeader = this.standardVariables.get(idx);
            aSimulationManagementPduHeader.marshal(buff);
        }
    }

    public void unmarshal(ByteBuffer buff) {
        this.numberOfStandardVariableRecords = buff.getShort() & 0xFFFF;
        for (int idx = 0; idx < this.numberOfStandardVariableRecords; ++idx) {
            SimulationManagementPduHeader anX = new SimulationManagementPduHeader();
            anX.unmarshal(buff);
            this.standardVariables.add(anX);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof StandardVariableSpecification)) {
            return false;
        }
        StandardVariableSpecification rhs = (StandardVariableSpecification)obj;
        if (this.numberOfStandardVariableRecords != rhs.numberOfStandardVariableRecords) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.standardVariables.size(); ++idx) {
            if (this.standardVariables.get(idx).equals(rhs.standardVariables.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

