/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.AntennaPattern;
import edu.nps.moves.dis7.AntennaPatternGeneric;
import edu.nps.moves.dis7.BeamAntennaPattern;
import edu.nps.moves.dis7.CcttSincgarsModulationParameters;
import edu.nps.moves.dis7.EntityID;
import edu.nps.moves.dis7.EntityType;
import edu.nps.moves.dis7.JtidsMidsModulationParameters;
import edu.nps.moves.dis7.ModulationParameters;
import edu.nps.moves.dis7.ModulationParametersGeneric;
import edu.nps.moves.dis7.ModulationType;
import edu.nps.moves.dis7.RadioCommunicationsFamilyPdu;
import edu.nps.moves.dis7.VariableTransmitterParameters;
import edu.nps.moves.dis7.Vector3Double;
import edu.nps.moves.dis7.Vector3Float;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TransmitterPdu
extends RadioCommunicationsFamilyPdu
implements Serializable {
    protected EntityID radioReferenceID = new EntityID();
    protected int radioNumber;
    protected EntityType radioEntityType = new EntityType();
    protected short transmitState;
    protected short inputSource;
    protected int variableTransmitterParameterCount;
    protected Vector3Double antennaLocation = new Vector3Double();
    protected Vector3Float relativeAntennaLocation = new Vector3Float();
    protected int antennaPatternType;
    protected int antennaPatternCount;
    protected long frequency;
    protected float transmitFrequencyBandwidth;
    protected float power;
    protected ModulationType modulationType = new ModulationType();
    protected int cryptoSystem;
    protected int cryptoKeyId;
    protected short modulationParameterCount;
    protected int padding2 = 0;
    protected short padding3 = 0;
    protected ModulationParameters modulationParameters = new ModulationParameters();
    protected AntennaPattern antennaPattern = new AntennaPattern();
    protected List<VariableTransmitterParameters> variableTransmitterParametersList = new ArrayList<VariableTransmitterParameters>();

    public TransmitterPdu() {
        this.setPduType((short)25);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.radioReferenceID.getMarshalledSize();
        marshalSize += 2;
        marshalSize += this.radioEntityType.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        marshalSize += 2;
        marshalSize += this.antennaLocation.getMarshalledSize();
        marshalSize += this.relativeAntennaLocation.getMarshalledSize();
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 8;
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += this.modulationType.getMarshalledSize();
        marshalSize += 2;
        marshalSize += 2;
        ++marshalSize;
        marshalSize += 2;
        ++marshalSize;
        int nrOfModulationBytes = 0;
        switch (this.getModulationType().getRadioSystem()) {
            case 6: {
                if (!(this.modulationParameters instanceof CcttSincgarsModulationParameters)) break;
                CcttSincgarsModulationParameters ccttSincgarsModulationParameters = (CcttSincgarsModulationParameters)this.modulationParameters;
                marshalSize += ccttSincgarsModulationParameters.getMarshalledSize();
                nrOfModulationBytes += ccttSincgarsModulationParameters.getMarshalledSize();
                break;
            }
            case 8: {
                if (!(this.modulationParameters instanceof JtidsMidsModulationParameters)) break;
                JtidsMidsModulationParameters jtidsMidsModulationParameters = (JtidsMidsModulationParameters)this.modulationParameters;
                marshalSize += jtidsMidsModulationParameters.getMarshalledSize();
                nrOfModulationBytes += jtidsMidsModulationParameters.getMarshalledSize();
                break;
            }
            default: {
                if (!(this.modulationParameters instanceof ModulationParametersGeneric)) break;
                ModulationParametersGeneric modPar = (ModulationParametersGeneric)this.modulationParameters;
                marshalSize += modPar.getMarshalledSize();
                nrOfModulationBytes += modPar.getMarshalledSize();
            }
        }
        if (nrOfModulationBytes % 8 > 0) {
            int remainder = nrOfModulationBytes % 8;
            switch (remainder) {
                case 1: {
                    marshalSize += 7;
                    break;
                }
                case 2: {
                    marshalSize += 6;
                    break;
                }
                case 3: {
                    marshalSize += 5;
                    break;
                }
                case 4: {
                    marshalSize += 4;
                    break;
                }
                case 5: {
                    marshalSize += 3;
                    break;
                }
                case 6: {
                    marshalSize += 2;
                    break;
                }
                case 7: {
                    ++marshalSize;
                }
            }
        }
        switch (this.antennaPatternType) {
            case 1: {
                if (!(this.antennaPattern instanceof BeamAntennaPattern)) break;
                marshalSize += ((BeamAntennaPattern)this.antennaPattern).getMarshalledSize();
                break;
            }
            case 6: {
                break;
            }
            default: {
                if (!(this.antennaPattern instanceof AntennaPatternGeneric)) break;
                marshalSize += ((AntennaPatternGeneric)this.antennaPattern).getMarshalledSize();
            }
        }
        Iterator<VariableTransmitterParameters> iter = this.variableTransmitterParametersList.iterator();
        while (iter.hasNext()) {
            marshalSize += iter.next().getMarshalledSize();
        }
        return marshalSize;
    }

    public void setRadioReferenceID(EntityID pRadioReferenceID) {
        this.radioReferenceID = pRadioReferenceID;
    }

    public EntityID getRadioReferenceID() {
        return this.radioReferenceID;
    }

    public void setRadioNumber(int pRadioNumber) {
        this.radioNumber = pRadioNumber;
    }

    public int getRadioNumber() {
        return this.radioNumber;
    }

    public void setRadioEntityType(EntityType pRadioEntityType) {
        this.radioEntityType = pRadioEntityType;
    }

    public EntityType getRadioEntityType() {
        return this.radioEntityType;
    }

    public void setTransmitState(short pTransmitState) {
        this.transmitState = pTransmitState;
    }

    public short getTransmitState() {
        return this.transmitState;
    }

    public void setInputSource(short pInputSource) {
        this.inputSource = pInputSource;
    }

    public short getInputSource() {
        return this.inputSource;
    }

    public void setVariableTransmitterParameterCount(int pVariableTransmitterParameterCount) {
        this.variableTransmitterParameterCount = pVariableTransmitterParameterCount;
    }

    public int getVariableTransmitterParameterCount() {
        return this.variableTransmitterParameterCount;
    }

    public void setAntennaLocation(Vector3Double pAntennaLocation) {
        this.antennaLocation = pAntennaLocation;
    }

    public Vector3Double getAntennaLocation() {
        return this.antennaLocation;
    }

    public void setRelativeAntennaLocation(Vector3Float pRelativeAntennaLocation) {
        this.relativeAntennaLocation = pRelativeAntennaLocation;
    }

    public Vector3Float getRelativeAntennaLocation() {
        return this.relativeAntennaLocation;
    }

    public void setAntennaPatternType(int pAntennaPatternType) {
        this.antennaPatternType = pAntennaPatternType;
    }

    public int getAntennaPatternType() {
        return this.antennaPatternType;
    }

    public int getAntennaPatternCount() {
        int antennaPatternCount = 0;
        switch (this.antennaPatternType) {
            case 1: {
                if (!(this.antennaPattern instanceof BeamAntennaPattern)) break;
                antennaPatternCount = ((BeamAntennaPattern)this.antennaPattern).getMarshalledSize();
                break;
            }
            case 6: {
                break;
            }
            default: {
                if (!(this.antennaPattern instanceof AntennaPatternGeneric)) break;
                antennaPatternCount = ((AntennaPatternGeneric)this.antennaPattern).getMarshalledSize();
            }
        }
        return antennaPatternCount;
    }

    public void setAntennaPatternCount(int pAntennaPatternCount) {
        this.antennaPatternCount = pAntennaPatternCount;
    }

    public void setFrequency(long pFrequency) {
        this.frequency = pFrequency;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public void setTransmitFrequencyBandwidth(float pTransmitFrequencyBandwidth) {
        this.transmitFrequencyBandwidth = pTransmitFrequencyBandwidth;
    }

    public float getTransmitFrequencyBandwidth() {
        return this.transmitFrequencyBandwidth;
    }

    public void setPower(float pPower) {
        this.power = pPower;
    }

    public float getPower() {
        return this.power;
    }

    public void setModulationType(ModulationType pModulationType) {
        this.modulationType = pModulationType;
    }

    public ModulationType getModulationType() {
        return this.modulationType;
    }

    public void setCryptoSystem(int pCryptoSystem) {
        this.cryptoSystem = pCryptoSystem;
    }

    public int getCryptoSystem() {
        return this.cryptoSystem;
    }

    public void setCryptoKeyId(int pCryptoKeyId) {
        this.cryptoKeyId = pCryptoKeyId;
    }

    public int getCryptoKeyId() {
        return this.cryptoKeyId;
    }

    public short getModulationParameterCount() {
        int modulationParameterOctets = 0;
        switch (this.getModulationType().getRadioSystem()) {
            case 6: {
                if (!(this.modulationParameters instanceof CcttSincgarsModulationParameters)) break;
                CcttSincgarsModulationParameters ccttSincgarsModulationParameters = (CcttSincgarsModulationParameters)this.modulationParameters;
                modulationParameterOctets = ccttSincgarsModulationParameters.getMarshalledSize();
                break;
            }
            case 8: {
                if (!(this.modulationParameters instanceof JtidsMidsModulationParameters)) break;
                JtidsMidsModulationParameters jtidsMidsModulationParameters = (JtidsMidsModulationParameters)this.modulationParameters;
                modulationParameterOctets = jtidsMidsModulationParameters.getMarshalledSize();
                break;
            }
            default: {
                if (!(this.modulationParameters instanceof ModulationParametersGeneric)) break;
                modulationParameterOctets = ((ModulationParametersGeneric)this.modulationParameters).getMarshalledSize();
            }
        }
        return (short)modulationParameterOctets;
    }

    public void setModulationParameterCount(short pModulationParameterCount) {
        this.modulationParameterCount = pModulationParameterCount;
    }

    public void setPadding2(int pPadding2) {
        this.padding2 = pPadding2;
    }

    public int getPadding2() {
        return this.padding2;
    }

    public void setPadding3(short pPadding3) {
        this.padding3 = pPadding3;
    }

    public short getPadding3() {
        return this.padding3;
    }

    public void setModulationParameters(ModulationParameters pModulationParameters) {
        this.modulationParameters = pModulationParameters;
    }

    public ModulationParameters getModulationParameters() {
        return this.modulationParameters;
    }

    public void setAntennaPattern(AntennaPattern pAntennaPatternList) {
        this.antennaPattern = pAntennaPatternList;
    }

    public AntennaPattern getAntennaPattern() {
        return this.antennaPattern;
    }

    public List<VariableTransmitterParameters> getVariableTransmitterParametersList() {
        return this.variableTransmitterParametersList;
    }

    public void setVariableTransmitterParametersList(List<VariableTransmitterParameters> variableTransmitterParametersList) {
        this.variableTransmitterParametersList = variableTransmitterParametersList;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            this.radioReferenceID.marshal(dos);
            dos.writeShort((short)this.radioNumber);
            this.radioEntityType.marshal(dos);
            dos.writeByte((byte)this.transmitState);
            dos.writeByte((byte)this.inputSource);
            dos.writeShort((short)this.variableTransmitterParametersList.size());
            this.antennaLocation.marshal(dos);
            this.relativeAntennaLocation.marshal(dos);
            dos.writeShort((short)this.antennaPatternType);
            dos.writeShort((short)this.getAntennaPatternCount());
            dos.writeLong(this.frequency);
            dos.writeFloat(this.transmitFrequencyBandwidth);
            dos.writeFloat(this.power);
            this.modulationType.marshal(dos);
            dos.writeShort((short)this.cryptoSystem);
            dos.writeShort((short)this.cryptoKeyId);
            dos.writeByte((byte)this.getModulationParameterCount());
            dos.writeShort((short)this.padding2);
            dos.writeByte((byte)this.padding3);
            int nrOfModulationBytes = 0;
            switch (this.getModulationType().getRadioSystem()) {
                case 6: {
                    if (!(this.modulationParameters instanceof CcttSincgarsModulationParameters)) break;
                    CcttSincgarsModulationParameters ccttSincgarsModulationParameters = (CcttSincgarsModulationParameters)this.modulationParameters;
                    ccttSincgarsModulationParameters.marshal(dos);
                    nrOfModulationBytes += ccttSincgarsModulationParameters.getMarshalledSize();
                    break;
                }
                case 8: {
                    if (!(this.modulationParameters instanceof JtidsMidsModulationParameters)) break;
                    JtidsMidsModulationParameters parameterRecord = (JtidsMidsModulationParameters)this.modulationParameters;
                    parameterRecord.marshal(dos);
                    nrOfModulationBytes += parameterRecord.getMarshalledSize();
                    break;
                }
                default: {
                    if (!(this.modulationParameters instanceof ModulationParametersGeneric)) break;
                    ModulationParametersGeneric modulationParameter = (ModulationParametersGeneric)this.modulationParameters;
                    modulationParameter.marshal(dos);
                    nrOfModulationBytes += nrOfModulationBytes + modulationParameter.getMarshalledSize();
                    break;
                }
            }
            if (nrOfModulationBytes % 8 > 0) {
                int remainder = 0;
                switch (nrOfModulationBytes % 8) {
                    case 1: {
                        remainder = 7;
                        break;
                    }
                    case 2: {
                        remainder = 6;
                        break;
                    }
                    case 3: {
                        remainder = 5;
                        break;
                    }
                    case 4: {
                        remainder = 4;
                        break;
                    }
                    case 5: {
                        remainder = 3;
                        break;
                    }
                    case 6: {
                        remainder = 2;
                        break;
                    }
                    case 7: {
                        remainder = 1;
                    }
                }
                for (int i = 1; i <= remainder; ++i) {
                    dos.writeByte(0);
                }
            }
            switch (this.antennaPatternType) {
                case 1: {
                    if (!(this.antennaPattern instanceof BeamAntennaPattern)) break;
                    ((BeamAntennaPattern)this.antennaPattern).marshal(dos);
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    if (!(this.antennaPattern instanceof AntennaPatternGeneric)) break;
                    ((AntennaPatternGeneric)this.antennaPattern).marshal(dos);
                }
            }
            for (int idx = 0; idx < this.variableTransmitterParametersList.size(); ++idx) {
                this.variableTransmitterParametersList.get(idx).marshal(dos);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            this.radioReferenceID.unmarshal(dis);
            this.radioNumber = dis.readUnsignedShort();
            this.radioEntityType.unmarshal(dis);
            this.transmitState = (short)dis.readUnsignedByte();
            this.inputSource = (short)dis.readUnsignedByte();
            this.variableTransmitterParameterCount = dis.readUnsignedShort();
            this.antennaLocation.unmarshal(dis);
            this.relativeAntennaLocation.unmarshal(dis);
            this.antennaPatternType = dis.readUnsignedShort();
            this.antennaPatternCount = dis.readUnsignedShort();
            this.frequency = dis.readLong();
            this.transmitFrequencyBandwidth = dis.readFloat();
            this.power = dis.readFloat();
            this.modulationType.unmarshal(dis);
            this.cryptoSystem = dis.readUnsignedShort();
            this.cryptoKeyId = dis.readUnsignedShort();
            this.modulationParameterCount = (short)dis.readUnsignedByte();
            this.padding2 = dis.readUnsignedShort();
            this.padding3 = (short)dis.readUnsignedByte();
            int remainder = 0;
            int modRecordSize = 0;
            switch (this.getModulationType().getRadioSystem()) {
                case 6: {
                    CcttSincgarsModulationParameters ccttSincgarsModulationParameters = new CcttSincgarsModulationParameters();
                    ccttSincgarsModulationParameters.unmarshal(dis);
                    this.modulationParameters = ccttSincgarsModulationParameters;
                    modRecordSize = 15;
                    break;
                }
                case 8: {
                    JtidsMidsModulationParameters jtidsMidsModulationParameters = new JtidsMidsModulationParameters();
                    jtidsMidsModulationParameters.unmarshal(dis);
                    this.modulationParameters = jtidsMidsModulationParameters;
                    modRecordSize = 8;
                    break;
                }
                default: {
                    ModulationParametersGeneric modPar = new ModulationParametersGeneric();
                    modPar.unmarshal(dis, (int)this.modulationParameterCount);
                    this.modulationParameters = modPar;
                    modRecordSize = modPar.getMarshalledSize();
                }
            }
            if (modRecordSize % 8 != 0) {
                remainder = 8 - modRecordSize % 8;
                for (int i = 1; i <= remainder; ++i) {
                    dis.readByte();
                }
            }
            switch (this.antennaPatternType) {
                case 1: {
                    BeamAntennaPattern beamAntennaPattern = new BeamAntennaPattern();
                    beamAntennaPattern.unmarshal(dis);
                    this.antennaPattern = beamAntennaPattern;
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    AntennaPatternGeneric antennaPatternGeneric = new AntennaPatternGeneric();
                    for (int i = 0; i < this.antennaPatternCount; ++i) {
                        antennaPatternGeneric.unmarshal(dis, this.antennaPatternCount);
                    }
                    this.antennaPattern = antennaPatternGeneric;
                }
            }
            for (int idx = 0; idx < this.variableTransmitterParameterCount; ++idx) {
                VariableTransmitterParameters varTransPar = new VariableTransmitterParameters();
                varTransPar.unmarshal(dis);
                this.variableTransmitterParametersList.add(varTransPar);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.radioReferenceID.marshal(buff);
        buff.putShort((short)this.radioNumber);
        this.radioEntityType.marshal(buff);
        buff.put((byte)this.transmitState);
        buff.put((byte)this.inputSource);
        buff.putShort((short)this.variableTransmitterParametersList.size());
        this.antennaLocation.marshal(buff);
        this.relativeAntennaLocation.marshal(buff);
        buff.putShort((short)this.antennaPatternType);
        buff.putShort((short)this.getAntennaPatternCount());
        buff.putLong(this.frequency);
        buff.putFloat(this.transmitFrequencyBandwidth);
        buff.putFloat(this.power);
        this.modulationType.marshal(buff);
        buff.putShort((short)this.cryptoSystem);
        buff.putShort((short)this.cryptoKeyId);
        buff.put((byte)this.getModulationParameterCount());
        buff.putShort((short)this.padding2);
        buff.put((byte)this.padding3);
        int nrOfModulationBytes = 0;
        switch (this.getModulationType().getRadioSystem()) {
            case 6: {
                CcttSincgarsModulationParameters ccttSincgarsModulationParameters = (CcttSincgarsModulationParameters)this.modulationParameters;
                ccttSincgarsModulationParameters.marshal(buff);
                nrOfModulationBytes += ccttSincgarsModulationParameters.getMarshalledSize();
                break;
            }
            case 8: {
                JtidsMidsModulationParameters parameterRecord = (JtidsMidsModulationParameters)this.modulationParameters;
                parameterRecord.marshal(buff);
                nrOfModulationBytes += parameterRecord.getMarshalledSize();
                break;
            }
            default: {
                ModulationParametersGeneric modulationParameter = (ModulationParametersGeneric)this.modulationParameters;
                modulationParameter.marshal(buff);
                nrOfModulationBytes += nrOfModulationBytes + modulationParameter.getMarshalledSize();
            }
        }
        if (nrOfModulationBytes % 8 > 0) {
            int remainder = 0;
            switch (nrOfModulationBytes % 8) {
                case 1: {
                    remainder = 7;
                    break;
                }
                case 2: {
                    remainder = 6;
                    break;
                }
                case 3: {
                    remainder = 5;
                    break;
                }
                case 4: {
                    remainder = 4;
                    break;
                }
                case 5: {
                    remainder = 3;
                    break;
                }
                case 6: {
                    remainder = 2;
                    break;
                }
                case 7: {
                    remainder = 1;
                }
            }
            for (int i = 1; i <= remainder; ++i) {
                buff.put((byte)0);
            }
        }
        switch (this.antennaPatternType) {
            case 1: {
                ((BeamAntennaPattern)this.antennaPattern).marshal(buff);
                break;
            }
            case 6: {
                break;
            }
            default: {
                ((AntennaPatternGeneric)this.antennaPattern).marshal(buff);
            }
        }
        for (int idx = 0; idx < this.variableTransmitterParametersList.size(); ++idx) {
            this.variableTransmitterParametersList.get(idx).marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.radioReferenceID.unmarshal(buff);
        this.radioNumber = buff.getShort() & 0xFFFF;
        this.radioEntityType.unmarshal(buff);
        this.transmitState = (short)(buff.get() & 0xFF);
        this.inputSource = (short)(buff.get() & 0xFF);
        this.variableTransmitterParameterCount = buff.getShort() & 0xFFFF;
        this.antennaLocation.unmarshal(buff);
        this.relativeAntennaLocation.unmarshal(buff);
        this.antennaPatternType = buff.getShort() & 0xFFFF;
        this.antennaPatternCount = buff.getShort() & 0xFFFF;
        this.frequency = buff.getLong();
        this.transmitFrequencyBandwidth = buff.getFloat();
        this.power = buff.getFloat();
        this.modulationType.unmarshal(buff);
        this.cryptoSystem = buff.getShort() & 0xFFFF;
        this.cryptoKeyId = buff.getShort() & 0xFFFF;
        this.modulationParameterCount = (short)(buff.get() & 0xFF);
        this.padding2 = buff.getShort() & 0xFFFF;
        this.padding3 = (short)(buff.get() & 0xFF);
        int remainder = 0;
        int modRecordSize = 0;
        switch (this.getModulationType().getRadioSystem()) {
            case 6: {
                CcttSincgarsModulationParameters ccttSincgarsModulationParameters = new CcttSincgarsModulationParameters();
                ccttSincgarsModulationParameters.unmarshal(buff);
                this.modulationParameters = ccttSincgarsModulationParameters;
                modRecordSize = 15;
                break;
            }
            case 8: {
                JtidsMidsModulationParameters jtidsMidsModulationParameters = new JtidsMidsModulationParameters();
                jtidsMidsModulationParameters.unmarshal(buff);
                this.modulationParameters = jtidsMidsModulationParameters;
                modRecordSize = 8;
                break;
            }
            default: {
                ModulationParametersGeneric modPar = new ModulationParametersGeneric();
                modPar.unmarshal(buff, (int)this.modulationParameterCount);
                this.modulationParameters = modPar;
                modRecordSize = modPar.getMarshalledSize();
            }
        }
        if (modRecordSize % 8 != 0) {
            remainder = 8 - modRecordSize % 8;
            for (int i = 1; i <= remainder; ++i) {
                buff.get();
            }
        }
        switch (this.antennaPatternType) {
            case 1: {
                BeamAntennaPattern beamAntennaPattern = new BeamAntennaPattern();
                beamAntennaPattern.unmarshal(buff);
                this.antennaPattern = beamAntennaPattern;
                break;
            }
            case 6: {
                break;
            }
            default: {
                AntennaPatternGeneric antennaPatternGeneric = new AntennaPatternGeneric();
                for (int i = 0; i < this.antennaPatternCount; ++i) {
                    antennaPatternGeneric.unmarshal(buff, this.antennaPatternCount);
                }
                this.antennaPattern = antennaPatternGeneric;
            }
        }
        for (int idx = 0; idx < this.variableTransmitterParameterCount; ++idx) {
            VariableTransmitterParameters varTransPar = new VariableTransmitterParameters();
            varTransPar.unmarshal(buff);
            this.variableTransmitterParametersList.add(varTransPar);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof TransmitterPdu)) {
            return false;
        }
        TransmitterPdu rhs = (TransmitterPdu)obj;
        if (!this.radioReferenceID.equals(rhs.radioReferenceID)) {
            ivarsEqual = false;
        }
        if (this.radioNumber != rhs.radioNumber) {
            ivarsEqual = false;
        }
        if (!this.radioEntityType.equals(rhs.radioEntityType)) {
            ivarsEqual = false;
        }
        if (this.transmitState != rhs.transmitState) {
            ivarsEqual = false;
        }
        if (this.inputSource != rhs.inputSource) {
            ivarsEqual = false;
        }
        if (this.variableTransmitterParameterCount != rhs.variableTransmitterParameterCount) {
            ivarsEqual = false;
        }
        if (!this.antennaLocation.equals(rhs.antennaLocation)) {
            ivarsEqual = false;
        }
        if (!this.relativeAntennaLocation.equals(rhs.relativeAntennaLocation)) {
            ivarsEqual = false;
        }
        if (this.antennaPatternType != rhs.antennaPatternType) {
            ivarsEqual = false;
        }
        if (this.antennaPatternCount != rhs.antennaPatternCount) {
            ivarsEqual = false;
        }
        if (this.frequency != rhs.frequency) {
            ivarsEqual = false;
        }
        if (this.transmitFrequencyBandwidth != rhs.transmitFrequencyBandwidth) {
            ivarsEqual = false;
        }
        if (this.power != rhs.power) {
            ivarsEqual = false;
        }
        if (!this.modulationType.equals(rhs.modulationType)) {
            ivarsEqual = false;
        }
        if (this.cryptoSystem != rhs.cryptoSystem) {
            ivarsEqual = false;
        }
        if (this.cryptoKeyId != rhs.cryptoKeyId) {
            ivarsEqual = false;
        }
        if (this.modulationParameterCount != rhs.modulationParameterCount) {
            ivarsEqual = false;
        }
        if (this.padding2 != rhs.padding2) {
            ivarsEqual = false;
        }
        if (this.padding3 != rhs.padding3) {
            ivarsEqual = false;
        }
        switch (this.getModulationType().getRadioSystem()) {
            case 6: {
                if (((CcttSincgarsModulationParameters)this.modulationParameters).equals((CcttSincgarsModulationParameters)rhs.modulationParameters)) break;
                ivarsEqual = false;
                break;
            }
            case 8: {
                if (((JtidsMidsModulationParameters)this.modulationParameters).equals((JtidsMidsModulationParameters)rhs.modulationParameters)) break;
                ivarsEqual = false;
                break;
            }
            default: {
                if (((ModulationParametersGeneric)this.modulationParameters).equals((ModulationParametersGeneric)rhs.modulationParameters)) break;
                ivarsEqual = false;
            }
        }
        switch (this.antennaPatternType) {
            case 1: {
                if (((BeamAntennaPattern)this.antennaPattern).equals((BeamAntennaPattern)rhs.antennaPattern)) break;
                ivarsEqual = false;
                break;
            }
            case 6: {
                break;
            }
            default: {
                if (this.antennaPattern.equals(rhs.antennaPattern)) break;
                ivarsEqual = false;
            }
        }
        for (int idx = 0; idx < this.variableTransmitterParametersList.size(); ++idx) {
            if (this.variableTransmitterParametersList.get(idx).equals(rhs.variableTransmitterParametersList.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

