/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class VariableTransmitterParameters
implements Serializable {
    protected long recordType;
    protected long recordLength = 4L;
    protected List<Byte> recordSpecificFieldsList = new ArrayList<Byte>();
    private final int RECORD_TYPE_FIELD_SIZE = 4;
    private final int RECORD_LENGTH_FIELD_SIZE = 2;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 4;
        marshalSize += 2;
        int remainder = (marshalSize += this.recordSpecificFieldsList.size()) % 8;
        if (remainder > 0) {
            marshalSize += this.calculatePaddingByteNr(remainder);
        }
        return marshalSize;
    }

    public void setRecordType(long pRecordType) {
        this.recordType = pRecordType;
    }

    public long getRecordType() {
        return this.recordType;
    }

    public void setRecordLength(long pRecordLength) {
        this.recordLength = pRecordLength;
    }

    public long getRecordLength() {
        return this.recordLength;
    }

    public List<Byte> getRecordSpecificFieldsList() {
        return this.recordSpecificFieldsList;
    }

    public void setRecordSpecificFieldsList(List<Byte> recordSpecificFieldsList) {
        this.recordSpecificFieldsList = recordSpecificFieldsList;
    }

    private int calculatePaddingByteNr(int remainder) {
        int paddingByteNr = 0;
        switch (remainder) {
            case 1: {
                paddingByteNr = 7;
                break;
            }
            case 2: {
                paddingByteNr = 6;
                break;
            }
            case 3: {
                paddingByteNr = 5;
                break;
            }
            case 4: {
                paddingByteNr = 4;
                break;
            }
            case 5: {
                paddingByteNr = 3;
                break;
            }
            case 6: {
                paddingByteNr = 2;
                break;
            }
            case 7: {
                paddingByteNr = 1;
            }
        }
        return paddingByteNr;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeInt((int)this.recordType);
            dos.writeShort(this.getMarshalledSize());
            for (byte nextByte : this.recordSpecificFieldsList) {
                dos.writeByte(nextByte);
            }
            int remainder = (this.recordSpecificFieldsList.size() + 4 + 2) % 8;
            if (remainder > 0) {
                int paddingByteNr = 0;
                paddingByteNr = this.calculatePaddingByteNr(remainder);
                for (int i = 0; i < paddingByteNr; ++i) {
                    dos.writeByte(0);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.recordType = dis.readInt();
            this.recordLength = dis.readShort();
            long dataLength = this.recordLength - 4L - 2L;
            int i = 0;
            while ((long)i < dataLength) {
                byte nextByte = dis.readByte();
                this.recordSpecificFieldsList.add(nextByte);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.putInt((int)this.recordType);
        buff.putShort((short)this.getMarshalledSize());
        for (byte nextByte : this.recordSpecificFieldsList) {
            buff.put(nextByte);
        }
        int remainder = this.recordSpecificFieldsList.size() % 8;
        if (remainder > 0) {
            int paddingByteNr = 0;
            paddingByteNr = this.calculatePaddingByteNr(remainder);
            for (int i = 0; i < paddingByteNr; ++i) {
                buff.put((byte)0);
            }
        }
    }

    public void unmarshal(ByteBuffer buff) {
        this.recordType = buff.getInt();
        this.recordLength = buff.getShort();
        long dataLength = this.recordLength - 4L - 2L;
        int i = 0;
        while ((long)i < dataLength) {
            byte nextByte = buff.get();
            this.recordSpecificFieldsList.add(nextByte);
            ++i;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof VariableTransmitterParameters)) {
            return false;
        }
        VariableTransmitterParameters rhs = (VariableTransmitterParameters)obj;
        if (this.recordType != rhs.recordType) {
            ivarsEqual = false;
        }
        if (this.recordLength != rhs.recordLength) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.recordSpecificFieldsList.size(); ++idx) {
            if (this.recordSpecificFieldsList.get(idx).equals(rhs.recordSpecificFieldsList.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

