/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.disutil;

public class CoordinateConversions {
    public static final double RADIANS_TO_DEGREES = 57.29577951308232;
    public static final double DEGREES_TO_RADIANS = Math.PI / 180;

    private CoordinateConversions() {
    }

    public static double[] xyzToLatLonRadians(double[] xyz) {
        double phi;
        double x = xyz[0];
        double y = xyz[1];
        double z = xyz[2];
        double[] answer = new double[3];
        double a = 6378137.0;
        double b = 6356752.3142;
        double W = Math.sqrt(x * x + y * y);
        double eSquared = (a * a - b * b) / (a * a);
        double ePrimeSquared = (a * a - b * b) / (b * b);
        answer[1] = x >= 0.0 ? Math.atan(y / x) : (x < 0.0 && y >= 0.0 ? Math.atan(y / x) + Math.PI : Math.atan(y / x) - Math.PI);
        double tanBZero = a * z / (b * W);
        double BZero = Math.atan(tanBZero);
        double tanPhi = (z + ePrimeSquared * b * Math.pow(Math.sin(BZero), 3.0)) / (W - a * eSquared * Math.pow(Math.cos(BZero), 3.0));
        answer[0] = phi = Math.atan(tanPhi);
        double rSubN = a * a / Math.sqrt(a * a * (Math.cos(phi) * Math.cos(phi)) + b * b * (Math.sin(phi) * Math.sin(phi)));
        answer[2] = W / Math.cos(phi) - rSubN;
        return answer;
    }

    public static double[] xyzToLatLonDegrees(double[] xyz) {
        double[] degrees = CoordinateConversions.xyzToLatLonRadians(xyz);
        degrees[0] = degrees[0] * 57.29577951308232;
        degrees[1] = degrees[1] * 57.29577951308232;
        return degrees;
    }

    public static double[] getXYZfromLatLonRadians(double latitude, double longitude, double height) {
        double a = 6378137.0;
        double b = 6356752.3142;
        double cosLat = Math.cos(latitude);
        double sinLat = Math.sin(latitude);
        double rSubN = a * a / Math.sqrt(a * a * (cosLat * cosLat) + b * b * (sinLat * sinLat));
        double X = (rSubN + height) * cosLat * Math.cos(longitude);
        double Y = (rSubN + height) * cosLat * Math.sin(longitude);
        double Z = (b * b / (a * a) * rSubN + height) * sinLat;
        return new double[]{X, Y, Z};
    }

    public static double[] getXYZfromLatLonDegrees(double latitude, double longitude, double height) {
        double[] degrees = CoordinateConversions.getXYZfromLatLonRadians(latitude * (Math.PI / 180), longitude * (Math.PI / 180), height);
        return degrees;
    }
}

