/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.disutil;

import edu.nps.moves.dis.Pdu;
import edu.nps.moves.disutil.PduFactory;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DisConnection
implements Runnable {
    private final DatagramSocket socket;
    private DatagramPacket packet;
    private InetAddress addr;
    private final PduFactory pduFactory = new PduFactory();
    private final BlockingQueue<Pdu> msgQ = new LinkedBlockingQueue<Pdu>();
    private static final int MAX_PDU_SIZE = 16384;
    private static final int MAX_PDU_QUEUE_SIZE = 500;

    public DisConnection(String multicastAddress, int port) throws IOException {
        this.init();
        this.socket = new MulticastSocket(port);
        this.addr = InetAddress.getByName(multicastAddress);
        ((MulticastSocket)this.socket).joinGroup(this.addr);
    }

    public DisConnection(int port) throws IOException {
        this.init();
        this.socket = new DatagramSocket(port);
    }

    private void init() {
        byte[] buffer = new byte[16384];
        this.packet = new DatagramPacket(buffer, buffer.length);
    }

    public void terminate() {
        this.socket.disconnect();
        try {
            if (this.socket instanceof MulticastSocket) {
                ((MulticastSocket)this.socket).leaveGroup(this.socket.getInetAddress());
            }
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMessage(Pdu pdu) {
        BlockingQueue<Pdu> blockingQueue = this.msgQ;
        synchronized (blockingQueue) {
            this.msgQ.add(pdu);
            if (this.msgQ.size() > 500) {
                Logger.getLogger(this.getClass().getName()).warning("Pdu buffer overflow, clearing.");
                this.msgQ.clear();
            }
        }
    }

    public synchronized Pdu getNext() throws InterruptedException {
        return this.msgQ.take();
    }

    public void send(Pdu pdu) throws IOException {
        this.socket.send(new DatagramPacket(pdu.marshal(), pdu.getLength(), this.addr, this.socket.getLocalPort()));
    }

    @Override
    public void run() {
        while (!Thread.interrupted()) {
            try {
                this.socket.receive(this.packet);
                Pdu pdu = this.pduFactory.createPdu(this.packet.getData());
                if (pdu == null) continue;
                this.handleMessage(pdu);
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                break;
            }
        }
        this.terminate();
    }
}

