/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.disutil;

public class EulerConversions {
    static double _toDegrees = 57.2957795131;
    static double _toRadians = 0.01745329252;

    public static double getOrientationFromEuler(double lat, double lon, double psi, double theta) {
        double sinlat = Math.sin(lat);
        double sinlon = Math.sin(lon);
        double coslon = Math.cos(lon);
        double coslat = Math.cos(lat);
        double sinsin = sinlat * sinlon;
        double cosTheta = Math.cos(theta);
        double cosPsi = Math.cos(psi);
        double sinPsi = Math.sin(psi);
        double sinTheta = Math.sin(theta);
        double cosThetaCosPsi = cosTheta * cosPsi;
        double cosThetaSinPsi = cosTheta * sinPsi;
        double sincos = sinlat * coslon;
        double b11 = -sinlon * cosThetaCosPsi + coslon * cosThetaSinPsi;
        double b12 = -sincos * cosThetaCosPsi - sinsin * cosThetaSinPsi - coslat * sinTheta;
        return Math.toDegrees(Math.atan2(b11, b12));
    }

    public static double getPitchFromEuler(double lat, double lon, double psi, double theta) {
        double sinlat = Math.sin(lat);
        double sinlon = Math.sin(lon);
        double coslon = Math.cos(lon);
        double coslat = Math.cos(lat);
        double cosLatCosLon = coslat * coslon;
        double cosLatSinLon = coslat * sinlon;
        double cosTheta = Math.cos(theta);
        double cosPsi = Math.cos(psi);
        double sinPsi = Math.sin(psi);
        double sinTheta = Math.sin(theta);
        return Math.toDegrees(Math.asin(cosLatCosLon * cosTheta * cosPsi + cosLatSinLon * cosTheta * sinPsi - sinlat * sinTheta));
    }

    public static double getRollFromEuler(double lat, double lon, double psi, double theta, double phi) {
        double sinlat = Math.sin(lat);
        double sinlon = Math.sin(lon);
        double coslon = Math.cos(lon);
        double coslat = Math.cos(lat);
        double cosLatCosLon = coslat * coslon;
        double cosLatSinLon = coslat * sinlon;
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double cosPsi = Math.cos(psi);
        double sinPsi = Math.sin(psi);
        double sinPhi = Math.sin(phi);
        double cosPhi = Math.cos(phi);
        double sinPhiSinTheta = sinPhi * sinTheta;
        double cosPhiSinTheta = cosPhi * sinTheta;
        double b23 = cosLatCosLon * (-cosPhi * sinPsi + sinPhiSinTheta * cosPsi) + cosLatSinLon * (cosPhi * cosPsi + sinPhiSinTheta * sinPsi) + sinlat * (sinPhi * cosTheta);
        double b33 = cosLatCosLon * (sinPhi * sinPsi + cosPhiSinTheta * cosPsi) + cosLatSinLon * (-sinPhi * cosPsi + cosPhiSinTheta * sinPsi) + sinlat * (cosPhi * cosTheta);
        return Math.toDegrees(Math.atan2(-b23, -b33));
    }

    public static double getThetaFromTaitBryanAngles(double lat, double lon, double yaw, double pitch) {
        double sinLat = Math.sin(lat);
        double cosLat = Math.cos(lat);
        double cosPitch = Math.cos(pitch * _toRadians);
        double sinPitch = Math.sin(pitch * _toRadians);
        double cosYaw = Math.cos(yaw * _toRadians);
        return Math.asin(-cosLat * cosYaw * cosPitch - sinLat * sinPitch);
    }

    public static double getPsiFromTaitBryanAngles(double lat, double lon, double yaw, double pitch) {
        double sinLat = Math.sin(lat);
        double sinLon = Math.sin(lon);
        double cosLon = Math.cos(lon);
        double cosLat = Math.cos(lat);
        double cosLatCosLon = cosLat * cosLon;
        double cosLatSinLon = cosLat * sinLon;
        double sinLatCosLon = sinLat * cosLon;
        double sinLatSinLon = sinLat * sinLon;
        double cosPitch = Math.cos(pitch * _toRadians);
        double sinPitch = Math.sin(pitch * _toRadians);
        double sinYaw = Math.sin(yaw * _toRadians);
        double cosYaw = Math.cos(yaw * _toRadians);
        double a_11 = -sinLon * sinYaw * cosPitch - sinLatCosLon * cosYaw * cosPitch + cosLatCosLon * sinPitch;
        double a_12 = cosLon * sinYaw * cosPitch - sinLatSinLon * cosYaw * cosPitch + cosLatSinLon * sinPitch;
        return Math.atan2(a_12, a_11);
    }

    public static double getPhiFromTaitBryanAngles(double lat, double lon, double yaw, double pitch, double roll) {
        double sinLat = Math.sin(lat);
        double cosLat = Math.cos(lat);
        double cosRoll = Math.cos(roll * _toRadians);
        double sinRoll = Math.sin(roll * _toRadians);
        double cosPitch = Math.cos(pitch * _toRadians);
        double sinPitch = Math.sin(pitch * _toRadians);
        double sinYaw = Math.sin(yaw * _toRadians);
        double cosYaw = Math.cos(yaw * _toRadians);
        double a_23 = cosLat * (-sinYaw * cosRoll + cosYaw * sinPitch * sinRoll) - sinLat * cosPitch * sinRoll;
        double a_33 = cosLat * (sinYaw * sinRoll + cosYaw * sinPitch * cosRoll) - sinLat * cosPitch * cosRoll;
        return Math.atan2(a_23, a_33);
    }
}

