/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.disutil;

import edu.nps.moves.dis.Pdu;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class PduContainer
implements Serializable {
    protected int numberOfPdus;
    protected List<Pdu> pdus = new ArrayList<Pdu>();

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 4;
        for (int idx = 0; idx < this.pdus.size(); ++idx) {
            Pdu listElement = this.pdus.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public int getNumberOfPdus() {
        return this.pdus.size();
    }

    public void setNumberOfPdus(int pNumberOfPdus) {
        this.numberOfPdus = pNumberOfPdus;
    }

    public void setPdus(List<Pdu> pPdus) {
        this.pdus = pPdus;
    }

    public List<Pdu> getPdus() {
        return this.pdus;
    }

    public void marshal(ByteBuffer buff) {
        buff.putInt(this.pdus.size());
        for (int idx = 0; idx < this.pdus.size(); ++idx) {
            Pdu aPdu = this.pdus.get(idx);
            aPdu.marshal(buff);
        }
    }

    public void unmarshal(ByteBuffer buff) {
        this.numberOfPdus = buff.getInt();
        for (int idx = 0; idx < this.numberOfPdus; ++idx) {
            Pdu anX = new Pdu();
            anX.unmarshal(buff);
            this.pdus.add(anX);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof PduContainer)) {
            return false;
        }
        PduContainer rhs = (PduContainer)obj;
        if (this.numberOfPdus != rhs.numberOfPdus) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.pdus.size(); ++idx) {
            if (this.pdus.get(idx).equals(rhs.pdus.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

