/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.examples;

import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.EntityStatePdu;
import edu.nps.moves.dis.Pdu;
import edu.nps.moves.dis.Vector3Double;
import edu.nps.moves.disutil.CoordinateConversions;
import edu.nps.moves.disutil.DisConnection;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EspduReceiver {
    public static void main(String[] args) throws IOException, InterruptedException {
        final DisConnection con = new DisConnection("239.1.2.3", 3000);
        new Thread(con).start();
        new Runnable(){

            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    try {
                        Pdu pdu = con.getNext();
                        if (pdu == null) continue;
                        System.out.println("Received PDU of type: " + pdu.getClass().getName());
                        if (!(pdu instanceof EntityStatePdu)) continue;
                        EntityStatePdu espdu = (EntityStatePdu)pdu;
                        System.out.println(" Marking: " + espdu.getMarking().getCharactersString());
                        EntityID eid = espdu.getEntityID();
                        System.out.println(" Site, App, Id: [" + eid.getSite() + ", " + eid.getApplication() + ", " + eid.getEntity() + "] ");
                        Vector3Double position = espdu.getEntityLocation();
                        System.out.println(" Location in DIS geocentric xyz coordinates: [" + position.getX() + ", " + position.getY() + ", " + position.getZ() + "]");
                        double[] latlon = CoordinateConversions.xyzToLatLonDegrees(position.toArray());
                        System.out.println(" Location in Latitude Longitude Elevation: [" + latlon[0] + ", " + latlon[1] + ", " + latlon[2] + "]");
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(DisConnection.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }.run();
    }
}

