/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.deadreckoning;

import edu.nps.moves.dis.ArticulationParameter;
import edu.nps.moves.dis.EntityStatePdu;
import edu.nps.moves.disenum.DeadReckoningAlgorithm;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.RotationConvention;
import org.apache.commons.math3.geometry.euclidean.threed.RotationOrder;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public class DeadReckoner {
    private static double MIN_ROTATION_RATE = 0.003490658503988659;
    private static double MIN_ACCELERATION_RATE = 0.1;

    public static void perform_DR(EntityStatePdu pESPDU, double deltaTime) {
        if (!DeadReckoningAlgorithm.enumerationForValueExists((int)pESPDU.getDeadReckoningParameters().getDeadReckoningAlgorithm()) || deltaTime < 0.0) {
            throw new IllegalArgumentException();
        }
        DeadReckoningAlgorithm DRalg = DeadReckoningAlgorithm.lookup[pESPDU.getDeadReckoningParameters().getDeadReckoningAlgorithm()];
        if (DRalg == DeadReckoningAlgorithm.OTHER) {
            throw new IllegalArgumentException();
        }
        if (deltaTime == 0.0) {
            return;
        }
        long dtimeStamp = 2L * (long)(deltaTime * 2.147483648E9 / 3600.0);
        pESPDU.setTimestamp(pESPDU.getTimestamp() + dtimeStamp);
        if (DRalg == DeadReckoningAlgorithm.STATIC_ENTITY_DOES_NOT_MOVE) {
            return;
        }
        Vector3D location = new Vector3D(pESPDU.getEntityLocation().getX(), pESPDU.getEntityLocation().getY(), pESPDU.getEntityLocation().getZ());
        Vector3D velocity = new Vector3D((double)pESPDU.getEntityLinearVelocity().getX(), (double)pESPDU.getEntityLinearVelocity().getY(), (double)pESPDU.getEntityLinearVelocity().getZ());
        Vector3D acceleration = new Vector3D((double)pESPDU.getDeadReckoningParameters().getEntityLinearAcceleration().getX(), (double)pESPDU.getDeadReckoningParameters().getEntityLinearAcceleration().getY(), (double)pESPDU.getDeadReckoningParameters().getEntityLinearAcceleration().getZ());
        double rotRateRoll = pESPDU.getDeadReckoningParameters().getEntityAngularVelocity().getX();
        double rotRatePitch = pESPDU.getDeadReckoningParameters().getEntityAngularVelocity().getY();
        double rotRateYaw = pESPDU.getDeadReckoningParameters().getEntityAngularVelocity().getZ();
        boolean rotating = false;
        if ((DRalg == DeadReckoningAlgorithm.DRMR_P_W || DRalg == DeadReckoningAlgorithm.DRMR_V_W || DRalg == DeadReckoningAlgorithm.DRMR_P_B || DRalg == DeadReckoningAlgorithm.DRMR_V_B) && (Math.abs(rotRateRoll) >= MIN_ROTATION_RATE || Math.abs(rotRatePitch) >= MIN_ROTATION_RATE || Math.abs(rotRateYaw) >= MIN_ROTATION_RATE)) {
            rotating = true;
        }
        boolean accelerating = false;
        if ((DRalg == DeadReckoningAlgorithm.DRMR_V_W || DRalg == DeadReckoningAlgorithm.DRMF_V_W || DRalg == DeadReckoningAlgorithm.DRMR_V_B || DRalg == DeadReckoningAlgorithm.DRMF_V_B) && (Math.abs(acceleration.getX()) >= MIN_ACCELERATION_RATE || Math.abs(acceleration.getY()) >= MIN_ACCELERATION_RATE || Math.abs(acceleration.getZ()) >= MIN_ACCELERATION_RATE)) {
            accelerating = true;
        }
        boolean bodyCoords = false;
        if (DRalg == DeadReckoningAlgorithm.DRMF_P_B || DRalg == DeadReckoningAlgorithm.DRMR_P_B || DRalg == DeadReckoningAlgorithm.DRMR_V_B || DRalg == DeadReckoningAlgorithm.DRMF_V_B) {
            bodyCoords = true;
        }
        Rotation WCStoECS1Mat = Rotation.IDENTITY;
        if (rotating || bodyCoords) {
            WCStoECS1Mat = new Rotation(RotationOrder.ZYX, RotationConvention.FRAME_TRANSFORM, (double)pESPDU.getEntityOrientation().getPsi(), (double)pESPDU.getEntityOrientation().getTheta(), (double)pESPDU.getEntityOrientation().getPhi());
        }
        Vector3D vDistECS1 = Vector3D.ZERO;
        Vector3D aDistECS1 = Vector3D.ZERO;
        if (rotating) {
            RealVector wVec = MatrixUtils.createRealVector((double[])new double[]{rotRateRoll, rotRatePitch, rotRateYaw});
            RealMatrix wOut = wVec.outerProduct(wVec);
            RealMatrix wMat = MatrixUtils.createRealMatrix((double[][])new double[][]{{0.0, -rotRateYaw, rotRatePitch}, {rotRateYaw, 0.0, -rotRateRoll}, {-rotRatePitch, rotRateRoll, 0.0}});
            double wMagSq = wVec.dotProduct(wVec);
            double wMag = Math.sqrt(wMagSq);
            double wMagT = wMag * deltaTime;
            double cosWMagT = Math.cos(wMagT);
            double term1 = (1.0 - cosWMagT) / wMagSq;
            double sinWMagT = Math.sin(wMagT);
            double term3 = sinWMagT / wMag;
            RealMatrix ECS1toECS2Mat = wOut.scalarMultiply(term1).add(MatrixUtils.createRealIdentityMatrix((int)3).scalarMultiply(cosWMagT)).subtract(wMat.scalarMultiply(term3));
            if (bodyCoords) {
                double wMag3 = wMagSq * wMag;
                double vIntTerm1 = (wMagT - sinWMagT) / wMag3;
                RealMatrix vIntECS2toECS1Mat = wOut.scalarMultiply(vIntTerm1).add(MatrixUtils.createRealIdentityMatrix((int)3).scalarMultiply(term3)).add(wMat.scalarMultiply(term1));
                vDistECS1 = new Vector3D(vIntECS2toECS1Mat.operate(MatrixUtils.createRealVector((double[])velocity.toArray())).toArray());
                if (accelerating) {
                    double wMag4 = wMag3 * wMag;
                    double aIntTerm2Top = cosWMagT + wMagT * sinWMagT - 1.0;
                    double aIntTerm1 = (0.5 * wMagT * wMagT - aIntTerm2Top) / wMag4;
                    double aIntTerm2 = aIntTerm2Top / wMagSq;
                    double aIntTerm3 = (sinWMagT - wMagT * cosWMagT) / wMag3;
                    RealMatrix aIntECS2toECS1Mat = wOut.scalarMultiply(aIntTerm1).add(MatrixUtils.createRealIdentityMatrix((int)3).scalarMultiply(aIntTerm2)).add(wMat.scalarMultiply(aIntTerm3));
                    aDistECS1 = new Vector3D(aIntECS2toECS1Mat.operate(MatrixUtils.createRealVector((double[])acceleration.toArray())).toArray());
                }
            }
            Rotation WCStoECS2Mat = new Rotation(ECS1toECS2Mat.getData(), 1.0E-15).applyTo(WCStoECS1Mat);
            double[] eulerAngles = WCStoECS2Mat.getAngles(RotationOrder.ZYX, RotationConvention.FRAME_TRANSFORM);
            pESPDU.getEntityOrientation().setPsi((float)eulerAngles[0]);
            pESPDU.getEntityOrientation().setTheta((float)eulerAngles[1]);
            pESPDU.getEntityOrientation().setPhi((float)eulerAngles[2]);
        }
        if (bodyCoords) {
            if (!rotating) {
                vDistECS1 = velocity.scalarMultiply(deltaTime);
            }
            if (accelerating) {
                velocity = velocity.add(deltaTime, (Vector)acceleration);
                if (!rotating) {
                    aDistECS1 = acceleration.scalarMultiply(0.5 * deltaTime * deltaTime);
                }
            }
            Vector3D distECS1 = new Vector3D(vDistECS1.add((Vector)aDistECS1).toArray());
            location = location.add((Vector)WCStoECS1Mat.applyInverseTo(distECS1));
        } else if (accelerating) {
            Vector3D finalVelWCS = velocity.add(deltaTime, (Vector)acceleration);
            location = location.add(0.5 * deltaTime, (Vector)velocity.add((Vector)finalVelWCS));
            velocity = finalVelWCS;
        } else {
            location = location.add(deltaTime, (Vector)velocity);
        }
        pESPDU.getEntityLocation().setX(location.getX());
        pESPDU.getEntityLocation().setY(location.getY());
        pESPDU.getEntityLocation().setZ(location.getZ());
        pESPDU.getEntityLinearVelocity().setX((float)velocity.getX());
        pESPDU.getEntityLinearVelocity().setY((float)velocity.getY());
        pESPDU.getEntityLinearVelocity().setZ((float)velocity.getZ());
        pESPDU.getDeadReckoningParameters().getEntityLinearAcceleration().setX((float)acceleration.getX());
        pESPDU.getDeadReckoningParameters().getEntityLinearAcceleration().setY((float)acceleration.getY());
        pESPDU.getDeadReckoningParameters().getEntityLinearAcceleration().setZ((float)acceleration.getZ());
        block6: for (ArticulationParameter thisRate : pESPDU.getArticulationParameters()) {
            if (thisRate.getParameterType() % 2 != 0) continue;
            for (ArticulationParameter thisVal : pESPDU.getArticulationParameters()) {
                if (thisVal.getParameterType() != thisRate.getParameterType() - 1 || thisVal.getPartAttachedTo() != thisRate.getPartAttachedTo()) continue;
                switch (thisVal.getParameterType() % 32) {
                    case 1: 
                    case 3: {
                        thisVal.setParameterValue(thisVal.getParameterValue() + thisRate.getParameterValue() * deltaTime);
                        if (thisVal.getParameterValue() > 1.0) {
                            thisVal.setParameterValue(1.0);
                            continue block6;
                        }
                        if (!(thisVal.getParameterValue() < 0.0)) continue block6;
                        thisVal.setParameterValue(0.0);
                        continue block6;
                    }
                    case 5: 
                    case 7: 
                    case 9: {
                        thisVal.setParameterValue(thisVal.getParameterValue() + thisRate.getParameterValue() * deltaTime);
                        continue block6;
                    }
                    case 11: 
                    case 13: {
                        thisVal.setParameterValue(thisVal.getParameterValue() + thisRate.getParameterValue() * deltaTime);
                        if ((double)thisVal.getParameterValueFirstSubfield() > Math.PI) {
                            thisVal.setParameterValue(thisVal.getParameterValue() - Math.PI * 2);
                            continue block6;
                        }
                        if (!((double)thisVal.getParameterValueFirstSubfield() < -Math.PI)) continue block6;
                        thisVal.setParameterValue(thisVal.getParameterValue() + Math.PI * 2);
                        continue block6;
                    }
                    case 15: {
                        thisVal.setParameterValue(thisVal.getParameterValue() + thisRate.getParameterValue() * deltaTime);
                        if (thisVal.getParameterValue() > Math.PI) {
                            thisVal.setParameterValue(thisVal.getParameterValue() - Math.PI * 2);
                            continue block6;
                        }
                        if (!(thisVal.getParameterValue() < -Math.PI)) continue block6;
                        thisVal.setParameterValue(thisVal.getParameterValue() + Math.PI * 2);
                        continue block6;
                    }
                }
                throw new IllegalArgumentException();
            }
        }
    }
}

