/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.deadreckoning;

import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.RotationConvention;
import org.apache.commons.math3.geometry.euclidean.threed.RotationOrder;

public class RotationUtils {
    public static Rotation ecef2body(double phi, double theta, double psi) {
        return new Rotation(RotationOrder.ZYX, RotationConvention.FRAME_TRANSFORM, psi, theta, phi);
    }

    public static Rotation body2ecef(double phi, double theta, double psi) {
        return new Rotation(RotationOrder.ZYX, RotationConvention.FRAME_TRANSFORM, psi, theta, phi).revert();
    }

    public static Rotation ned2body(double roll, double pitch, double yaw) {
        return new Rotation(RotationOrder.ZYX, RotationConvention.FRAME_TRANSFORM, yaw, pitch, roll);
    }

    public static Rotation body2ned(double roll, double pitch, double yaw) {
        return new Rotation(RotationOrder.ZYX, RotationConvention.FRAME_TRANSFORM, yaw, pitch, roll).revert();
    }

    public static Rotation ecefvec2nedvec(double latitude, double longitude) {
        return new Rotation(RotationOrder.ZYX, RotationConvention.FRAME_TRANSFORM, longitude, -latitude - 1.5707963267948966, 0.0);
    }

    public static Rotation nedvec2ecefvec(double latitude, double longitude) {
        return new Rotation(RotationOrder.ZYX, RotationConvention.FRAME_TRANSFORM, longitude, -latitude - 1.5707963267948966, 0.0).revert();
    }

    public static Rotation ecefvec2enuvec(double latitude, double longitude) {
        return new Rotation(RotationOrder.ZYX, RotationConvention.FRAME_TRANSFORM, longitude + 1.5707963267948966, 0.0, 1.5707963267948966 - latitude);
    }

    public static Rotation enuvec2ecefvec(double latitude, double longitude) {
        return new Rotation(RotationOrder.ZYX, RotationConvention.FRAME_TRANSFORM, longitude + 1.5707963267948966, 0.0, 1.5707963267948966 - latitude).revert();
    }

    public static double[] ned2ecefAngles(double roll, double pitch, double yaw, double latitude, double longitude) {
        double[] eulerAngles = RotationUtils.ned2body(roll, pitch, yaw).applyTo(RotationUtils.ecefvec2nedvec(latitude, longitude)).getAngles(RotationOrder.ZYX, RotationConvention.FRAME_TRANSFORM);
        double[] ecefAngles = new double[]{eulerAngles[2], eulerAngles[1], eulerAngles[0]};
        return ecefAngles;
    }

    public static double[] ecef2nedAngles(double phi, double theta, double psi, double latitude, double longitude) {
        double[] eulerAngles = RotationUtils.ecef2body(phi, theta, psi).applyTo(RotationUtils.nedvec2ecefvec(latitude, longitude)).getAngles(RotationOrder.ZYX, RotationConvention.FRAME_TRANSFORM);
        double[] bodyAngles = new double[]{eulerAngles[2], eulerAngles[1], eulerAngles[0]};
        return bodyAngles;
    }

    public static double[] body2worldAngularVelocities(double omegaX, double omegaY, double omegaZ, double phi, double theta) {
        double cosPhi = Math.cos(phi);
        double sinPhi = Math.sin(phi);
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double dThetaDt = omegaY * cosPhi - omegaZ * sinPhi;
        double dPsiDt = (omegaY * sinPhi + omegaZ * cosPhi) / cosTheta;
        double dPhiDt = omegaX + dPsiDt * sinTheta;
        return new double[]{dPhiDt, dThetaDt, dPsiDt};
    }

    public static double[] world2bodyAngularVelocities(double dPhiDt, double dThetaDt, double dPsiDt, double phi, double theta) {
        double cosPhi = Math.cos(phi);
        double sinPhi = Math.sin(phi);
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double omegaX = dPhiDt - dPsiDt * sinTheta;
        double omegaY = dThetaDt * cosPhi + dPsiDt * sinPhi * cosTheta;
        double omegaZ = -dThetaDt * sinPhi + dPsiDt * cosPhi * cosTheta;
        return new double[]{omegaX, omegaY, omegaZ};
    }

    @Deprecated
    public static boolean rotationThresholdExceeded(Rotation RA, Rotation RD, double DRA_ORIENT_THRESH) {
        return Rotation.distance((Rotation)RA, (Rotation)RD) > DRA_ORIENT_THRESH;
    }

    public static double deltaMatrixThreshold(double DRA_ORIENT_THRESH) {
        return 2.0 - 2.0 * Math.cos(DRA_ORIENT_THRESH);
    }

    public static boolean matrixThresholdExceeded(Rotation RA, Rotation RD, double delta) {
        Rotation RE = RD.applyInverseTo(RA);
        double[][] ME = RE.getMatrix();
        double trace = ME[0][0] + ME[1][1] + ME[2][2];
        return 3.0 - trace > delta;
    }

    public static double epsilonQuaternionThreshold(double DRA_ORIENT_THRESH) {
        return 1.0 - Math.cos(DRA_ORIENT_THRESH / 2.0);
    }

    public static boolean quaternionThresholdExceeded(Rotation RA, Rotation RD, double epsilon) {
        double S = RA.getQ0() * RD.getQ0() + RA.getQ1() * RD.getQ1() + RA.getQ2() * RD.getQ2() + RA.getQ3() * RD.getQ3();
        return 1.0 - S > epsilon;
    }
}

