/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.SimulationManagementFamilyPdu;
import edu.nps.moves.dis.UnsignedIntegerWrapper;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class DataQueryPdu
extends SimulationManagementFamilyPdu
implements Serializable {
    protected long requestID;
    protected long timeInterval;
    protected long numberOfFixedDatumRecords;
    protected long numberOfVariableDatumRecords;
    protected List<UnsignedIntegerWrapper> fixedDatums = new ArrayList<UnsignedIntegerWrapper>();
    protected List<UnsignedIntegerWrapper> variableDatums = new ArrayList<UnsignedIntegerWrapper>();

    public DataQueryPdu() {
        this.setPduType((short)18);
    }

    @Override
    public int getMarshalledSize() {
        UnsignedIntegerWrapper listElement;
        int idx;
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        for (idx = 0; idx < this.fixedDatums.size(); ++idx) {
            listElement = this.fixedDatums.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        for (idx = 0; idx < this.variableDatums.size(); ++idx) {
            listElement = this.variableDatums.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setRequestID(long pRequestID) {
        this.requestID = pRequestID;
    }

    public long getRequestID() {
        return this.requestID;
    }

    public void setTimeInterval(long pTimeInterval) {
        this.timeInterval = pTimeInterval;
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public long getNumberOfFixedDatumRecords() {
        return this.fixedDatums.size();
    }

    public void setNumberOfFixedDatumRecords(long pNumberOfFixedDatumRecords) {
        this.numberOfFixedDatumRecords = pNumberOfFixedDatumRecords;
    }

    public long getNumberOfVariableDatumRecords() {
        return this.variableDatums.size();
    }

    public void setNumberOfVariableDatumRecords(long pNumberOfVariableDatumRecords) {
        this.numberOfVariableDatumRecords = pNumberOfVariableDatumRecords;
    }

    public void setFixedDatums(List<UnsignedIntegerWrapper> pFixedDatums) {
        this.fixedDatums = pFixedDatums;
    }

    public List<UnsignedIntegerWrapper> getFixedDatums() {
        return this.fixedDatums;
    }

    public void setVariableDatums(List<UnsignedIntegerWrapper> pVariableDatums) {
        this.variableDatums = pVariableDatums;
    }

    public List<UnsignedIntegerWrapper> getVariableDatums() {
        return this.variableDatums;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        UnsignedIntegerWrapper aUnsignedIntegerWrapper;
        int idx;
        super.marshal(buff);
        buff.putInt((int)this.requestID);
        buff.putInt((int)this.timeInterval);
        buff.putInt(this.fixedDatums.size());
        buff.putInt(this.variableDatums.size());
        for (idx = 0; idx < this.fixedDatums.size(); ++idx) {
            aUnsignedIntegerWrapper = this.fixedDatums.get(idx);
            aUnsignedIntegerWrapper.marshal(buff);
        }
        for (idx = 0; idx < this.variableDatums.size(); ++idx) {
            aUnsignedIntegerWrapper = this.variableDatums.get(idx);
            aUnsignedIntegerWrapper.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        UnsignedIntegerWrapper anX;
        super.unmarshal(buff);
        this.requestID = buff.getInt();
        this.timeInterval = buff.getInt();
        this.numberOfFixedDatumRecords = buff.getInt();
        this.numberOfVariableDatumRecords = buff.getInt();
        int idx = 0;
        while ((long)idx < this.numberOfFixedDatumRecords) {
            anX = new UnsignedIntegerWrapper();
            anX.unmarshal(buff);
            this.fixedDatums.add(anX);
            ++idx;
        }
        idx = 0;
        while ((long)idx < this.numberOfVariableDatumRecords) {
            anX = new UnsignedIntegerWrapper();
            anX.unmarshal(buff);
            this.variableDatums.add(anX);
            ++idx;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        int idx;
        boolean ivarsEqual = true;
        if (!(obj instanceof DataQueryPdu)) {
            return false;
        }
        DataQueryPdu rhs = (DataQueryPdu)obj;
        if (this.requestID != rhs.requestID) {
            ivarsEqual = false;
        }
        if (this.timeInterval != rhs.timeInterval) {
            ivarsEqual = false;
        }
        if (this.numberOfFixedDatumRecords != rhs.numberOfFixedDatumRecords) {
            ivarsEqual = false;
        }
        if (this.numberOfVariableDatumRecords != rhs.numberOfVariableDatumRecords) {
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.fixedDatums.size(); ++idx) {
            if (this.fixedDatums.get(idx).equals(rhs.fixedDatums.get(idx))) continue;
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.variableDatums.size(); ++idx) {
            if (this.variableDatums.get(idx).equals(rhs.variableDatums.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

