/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.ArticulationParameter;
import edu.nps.moves.dis.BurstDescriptor;
import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.EventID;
import edu.nps.moves.dis.Vector3Double;
import edu.nps.moves.dis.Vector3Float;
import edu.nps.moves.dis.WarfareFamilyPdu;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class DetonationPdu
extends WarfareFamilyPdu
implements Serializable {
    protected EntityID munitionID = new EntityID();
    protected EventID eventID = new EventID();
    protected Vector3Float velocity = new Vector3Float();
    protected Vector3Double locationInWorldCoordinates = new Vector3Double();
    protected BurstDescriptor burstDescriptor = new BurstDescriptor();
    protected Vector3Float locationInEntityCoordinates = new Vector3Float();
    protected short detonationResult;
    protected short numberOfArticulationParameters;
    protected short pad = 0;
    protected List<ArticulationParameter> articulationParameters = new ArrayList<ArticulationParameter>();

    public DetonationPdu() {
        this.setPduType((short)3);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.munitionID.getMarshalledSize();
        marshalSize += this.eventID.getMarshalledSize();
        marshalSize += this.velocity.getMarshalledSize();
        marshalSize += this.locationInWorldCoordinates.getMarshalledSize();
        marshalSize += this.burstDescriptor.getMarshalledSize();
        marshalSize += this.locationInEntityCoordinates.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        marshalSize += 2;
        for (int idx = 0; idx < this.articulationParameters.size(); ++idx) {
            ArticulationParameter listElement = this.articulationParameters.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setMunitionID(EntityID pMunitionID) {
        this.munitionID = pMunitionID;
    }

    public EntityID getMunitionID() {
        return this.munitionID;
    }

    public void setEventID(EventID pEventID) {
        this.eventID = pEventID;
    }

    public EventID getEventID() {
        return this.eventID;
    }

    public void setVelocity(Vector3Float pVelocity) {
        this.velocity = pVelocity;
    }

    public Vector3Float getVelocity() {
        return this.velocity;
    }

    public void setLocationInWorldCoordinates(Vector3Double pLocationInWorldCoordinates) {
        this.locationInWorldCoordinates = pLocationInWorldCoordinates;
    }

    public Vector3Double getLocationInWorldCoordinates() {
        return this.locationInWorldCoordinates;
    }

    public void setBurstDescriptor(BurstDescriptor pBurstDescriptor) {
        this.burstDescriptor = pBurstDescriptor;
    }

    public BurstDescriptor getBurstDescriptor() {
        return this.burstDescriptor;
    }

    public void setLocationInEntityCoordinates(Vector3Float pLocationInEntityCoordinates) {
        this.locationInEntityCoordinates = pLocationInEntityCoordinates;
    }

    public Vector3Float getLocationInEntityCoordinates() {
        return this.locationInEntityCoordinates;
    }

    public void setDetonationResult(short pDetonationResult) {
        this.detonationResult = pDetonationResult;
    }

    public short getDetonationResult() {
        return this.detonationResult;
    }

    public short getNumberOfArticulationParameters() {
        return (short)this.articulationParameters.size();
    }

    public void setNumberOfArticulationParameters(short pNumberOfArticulationParameters) {
        this.numberOfArticulationParameters = pNumberOfArticulationParameters;
    }

    public void setPad(short pPad) {
        this.pad = pPad;
    }

    public short getPad() {
        return this.pad;
    }

    public void setArticulationParameters(List<ArticulationParameter> pArticulationParameters) {
        this.articulationParameters = pArticulationParameters;
    }

    public List<ArticulationParameter> getArticulationParameters() {
        return this.articulationParameters;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.munitionID.marshal(buff);
        this.eventID.marshal(buff);
        this.velocity.marshal(buff);
        this.locationInWorldCoordinates.marshal(buff);
        this.burstDescriptor.marshal(buff);
        this.locationInEntityCoordinates.marshal(buff);
        buff.put((byte)this.detonationResult);
        buff.put((byte)this.articulationParameters.size());
        buff.putShort(this.pad);
        for (int idx = 0; idx < this.articulationParameters.size(); ++idx) {
            ArticulationParameter aArticulationParameter = this.articulationParameters.get(idx);
            aArticulationParameter.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.munitionID.unmarshal(buff);
        this.eventID.unmarshal(buff);
        this.velocity.unmarshal(buff);
        this.locationInWorldCoordinates.unmarshal(buff);
        this.burstDescriptor.unmarshal(buff);
        this.locationInEntityCoordinates.unmarshal(buff);
        this.detonationResult = (short)(buff.get() & 0xFF);
        this.numberOfArticulationParameters = (short)(buff.get() & 0xFF);
        this.pad = buff.getShort();
        for (int idx = 0; idx < this.numberOfArticulationParameters; ++idx) {
            ArticulationParameter anX = new ArticulationParameter();
            anX.unmarshal(buff);
            this.articulationParameters.add(anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof DetonationPdu)) {
            return false;
        }
        DetonationPdu rhs = (DetonationPdu)obj;
        if (!this.munitionID.equals(rhs.munitionID)) {
            ivarsEqual = false;
        }
        if (!this.eventID.equals(rhs.eventID)) {
            ivarsEqual = false;
        }
        if (!this.velocity.equals(rhs.velocity)) {
            ivarsEqual = false;
        }
        if (!this.locationInWorldCoordinates.equals(rhs.locationInWorldCoordinates)) {
            ivarsEqual = false;
        }
        if (!this.burstDescriptor.equals(rhs.burstDescriptor)) {
            ivarsEqual = false;
        }
        if (!this.locationInEntityCoordinates.equals(rhs.locationInEntityCoordinates)) {
            ivarsEqual = false;
        }
        if (this.detonationResult != rhs.detonationResult) {
            ivarsEqual = false;
        }
        if (this.numberOfArticulationParameters != rhs.numberOfArticulationParameters) {
            ivarsEqual = false;
        }
        if (this.pad != rhs.pad) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.articulationParameters.size(); ++idx) {
            if (this.articulationParameters.get(idx).equals(rhs.articulationParameters.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

