/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.FundamentalParameterData;
import edu.nps.moves.dis.TrackJamTarget;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ElectronicEmissionBeamData
implements Serializable {
    protected short beamDataLength;
    protected short beamIDNumber;
    protected int beamParameterIndex;
    protected FundamentalParameterData fundamentalParameterData = new FundamentalParameterData();
    protected short beamFunction;
    protected short numberOfTrackJamTargets;
    protected short highDensityTrackJam;
    protected short pad4 = 0;
    protected long jammingModeSequence;
    protected List<TrackJamTarget> trackJamTargets = new ArrayList<TrackJamTarget>();

    public int getMarshalledSize() {
        int marshalSize = 0;
        ++marshalSize;
        ++marshalSize;
        marshalSize += 2;
        marshalSize += this.fundamentalParameterData.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        marshalSize += 4;
        for (int idx = 0; idx < this.trackJamTargets.size(); ++idx) {
            TrackJamTarget listElement = this.trackJamTargets.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public short getBeamDataLength() {
        return this.beamDataLength;
    }

    short calculateBeamDataLength() {
        return (short)(2 * this.getTrackJamTargets().size() + 13);
    }

    public void setBeamIDNumber(short pBeamIDNumber) {
        this.beamIDNumber = pBeamIDNumber;
    }

    public short getBeamIDNumber() {
        return this.beamIDNumber;
    }

    public void setBeamParameterIndex(int pBeamParameterIndex) {
        this.beamParameterIndex = pBeamParameterIndex;
    }

    public int getBeamParameterIndex() {
        return this.beamParameterIndex;
    }

    public void setFundamentalParameterData(FundamentalParameterData pFundamentalParameterData) {
        this.fundamentalParameterData = pFundamentalParameterData;
    }

    public FundamentalParameterData getFundamentalParameterData() {
        return this.fundamentalParameterData;
    }

    public void setBeamFunction(short pBeamFunction) {
        this.beamFunction = pBeamFunction;
    }

    public short getBeamFunction() {
        return this.beamFunction;
    }

    public short getNumberOfTrackJamTargets() {
        return (short)this.trackJamTargets.size();
    }

    public void setNumberOfTrackJamTargets(short pNumberOfTrackJamTargets) {
        this.numberOfTrackJamTargets = pNumberOfTrackJamTargets;
    }

    public void setHighDensityTrackJam(short pHighDensityTrackJam) {
        this.highDensityTrackJam = pHighDensityTrackJam;
    }

    public short getHighDensityTrackJam() {
        return this.highDensityTrackJam;
    }

    public void setPad4(short pPad4) {
        this.pad4 = pPad4;
    }

    public short getPad4() {
        return this.pad4;
    }

    public void setJammingModeSequence(long pJammingModeSequence) {
        this.jammingModeSequence = pJammingModeSequence;
    }

    public long getJammingModeSequence() {
        return this.jammingModeSequence;
    }

    public void setTrackJamTargets(List<TrackJamTarget> pTrackJamTargets) {
        this.trackJamTargets = pTrackJamTargets;
    }

    public List<TrackJamTarget> getTrackJamTargets() {
        return this.trackJamTargets;
    }

    public void marshal(ByteBuffer buff) {
        buff.put((byte)this.calculateBeamDataLength());
        buff.put((byte)this.beamIDNumber);
        buff.putShort((short)this.beamParameterIndex);
        this.fundamentalParameterData.marshal(buff);
        buff.put((byte)this.beamFunction);
        buff.put((byte)this.trackJamTargets.size());
        buff.put((byte)this.highDensityTrackJam);
        buff.put((byte)this.pad4);
        buff.putInt((int)this.jammingModeSequence);
        for (int idx = 0; idx < this.trackJamTargets.size(); ++idx) {
            TrackJamTarget aTrackJamTarget = this.trackJamTargets.get(idx);
            aTrackJamTarget.marshal(buff);
        }
    }

    public void unmarshal(ByteBuffer buff) {
        this.beamDataLength = (short)(buff.get() & 0xFF);
        this.beamIDNumber = (short)(buff.get() & 0xFF);
        this.beamParameterIndex = buff.getShort() & 0xFFFF;
        this.fundamentalParameterData.unmarshal(buff);
        this.beamFunction = (short)(buff.get() & 0xFF);
        this.numberOfTrackJamTargets = (short)(buff.get() & 0xFF);
        this.highDensityTrackJam = (short)(buff.get() & 0xFF);
        this.pad4 = (short)(buff.get() & 0xFF);
        this.jammingModeSequence = buff.getInt();
        for (int idx = 0; idx < this.numberOfTrackJamTargets; ++idx) {
            TrackJamTarget anX = new TrackJamTarget();
            anX.unmarshal(buff);
            this.trackJamTargets.add(anX);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof ElectronicEmissionBeamData)) {
            return false;
        }
        ElectronicEmissionBeamData rhs = (ElectronicEmissionBeamData)obj;
        if (this.beamDataLength != rhs.beamDataLength) {
            ivarsEqual = false;
        }
        if (this.beamIDNumber != rhs.beamIDNumber) {
            ivarsEqual = false;
        }
        if (this.beamParameterIndex != rhs.beamParameterIndex) {
            ivarsEqual = false;
        }
        if (!this.fundamentalParameterData.equals(rhs.fundamentalParameterData)) {
            ivarsEqual = false;
        }
        if (this.beamFunction != rhs.beamFunction) {
            ivarsEqual = false;
        }
        if (this.numberOfTrackJamTargets != rhs.numberOfTrackJamTargets) {
            ivarsEqual = false;
        }
        if (this.highDensityTrackJam != rhs.highDensityTrackJam) {
            ivarsEqual = false;
        }
        if (this.pad4 != rhs.pad4) {
            ivarsEqual = false;
        }
        if (this.jammingModeSequence != rhs.jammingModeSequence) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.trackJamTargets.size(); ++idx) {
            if (this.trackJamTargets.get(idx).equals(rhs.trackJamTargets.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

