/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.ElectronicEmissionBeamData;
import edu.nps.moves.dis.EmitterSystem;
import edu.nps.moves.dis.Vector3Float;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ElectronicEmissionSystemData
implements Serializable {
    protected short systemDataLength;
    protected short numberOfBeams;
    protected int emissionsPadding2 = 0;
    protected EmitterSystem emitterSystem = new EmitterSystem();
    protected Vector3Float location = new Vector3Float();
    protected List<ElectronicEmissionBeamData> beamDataRecords = new ArrayList<ElectronicEmissionBeamData>();

    public int getMarshalledSize() {
        int marshalSize = 0;
        ++marshalSize;
        ++marshalSize;
        marshalSize += 2;
        marshalSize += this.emitterSystem.getMarshalledSize();
        marshalSize += this.location.getMarshalledSize();
        for (int idx = 0; idx < this.beamDataRecords.size(); ++idx) {
            ElectronicEmissionBeamData listElement = this.beamDataRecords.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public short getSystemDataLength() {
        return this.systemDataLength;
    }

    private short calculateSystemDataLength() {
        short size = 5;
        for (int i = 0; i < this.beamDataRecords.size(); ++i) {
            ElectronicEmissionBeamData bd = this.beamDataRecords.get(i);
            size = (short)(size + bd.calculateBeamDataLength());
        }
        return size;
    }

    public short getNumberOfBeams() {
        return (short)this.beamDataRecords.size();
    }

    public void setNumberOfBeams(short pNumberOfBeams) {
        this.numberOfBeams = pNumberOfBeams;
    }

    public void setEmissionsPadding2(int pEmissionsPadding2) {
        this.emissionsPadding2 = pEmissionsPadding2;
    }

    public int getEmissionsPadding2() {
        return this.emissionsPadding2;
    }

    public void setEmitterSystem(EmitterSystem pEmitterSystem) {
        this.emitterSystem = pEmitterSystem;
    }

    public EmitterSystem getEmitterSystem() {
        return this.emitterSystem;
    }

    public void setLocation(Vector3Float pLocation) {
        this.location = pLocation;
    }

    public Vector3Float getLocation() {
        return this.location;
    }

    public void setBeamDataRecords(List<ElectronicEmissionBeamData> pBeamDataRecords) {
        this.beamDataRecords = pBeamDataRecords;
    }

    public List<ElectronicEmissionBeamData> getBeamDataRecords() {
        return this.beamDataRecords;
    }

    public void marshal(ByteBuffer buff) {
        buff.put((byte)this.calculateSystemDataLength());
        buff.put((byte)this.beamDataRecords.size());
        buff.putShort((short)this.emissionsPadding2);
        this.emitterSystem.marshal(buff);
        this.location.marshal(buff);
        for (int idx = 0; idx < this.beamDataRecords.size(); ++idx) {
            ElectronicEmissionBeamData aElectronicEmissionBeamData = this.beamDataRecords.get(idx);
            aElectronicEmissionBeamData.marshal(buff);
        }
    }

    public void unmarshal(ByteBuffer buff) {
        this.systemDataLength = (short)(buff.get() & 0xFF);
        this.numberOfBeams = (short)(buff.get() & 0xFF);
        this.emissionsPadding2 = buff.getShort() & 0xFFFF;
        this.emitterSystem.unmarshal(buff);
        this.location.unmarshal(buff);
        for (int idx = 0; idx < this.numberOfBeams; ++idx) {
            ElectronicEmissionBeamData anX = new ElectronicEmissionBeamData();
            anX.unmarshal(buff);
            this.beamDataRecords.add(anX);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof ElectronicEmissionSystemData)) {
            return false;
        }
        ElectronicEmissionSystemData rhs = (ElectronicEmissionSystemData)obj;
        if (this.systemDataLength != rhs.systemDataLength) {
            ivarsEqual = false;
        }
        if (this.numberOfBeams != rhs.numberOfBeams) {
            ivarsEqual = false;
        }
        if (this.emissionsPadding2 != rhs.emissionsPadding2) {
            ivarsEqual = false;
        }
        if (!this.emitterSystem.equals(rhs.emitterSystem)) {
            ivarsEqual = false;
        }
        if (!this.location.equals(rhs.location)) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.beamDataRecords.size(); ++idx) {
            if (this.beamDataRecords.get(idx).equals(rhs.beamDataRecords.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

