/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.DistributedEmissionsFamilyPdu;
import edu.nps.moves.dis.ElectronicEmissionSystemData;
import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.EventID;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ElectronicEmissionsPdu
extends DistributedEmissionsFamilyPdu
implements Serializable {
    protected EntityID emittingEntityID = new EntityID();
    protected EventID eventID = new EventID();
    protected short stateUpdateIndicator;
    protected short numberOfSystems;
    protected int paddingForEmissionsPdu;
    protected List<ElectronicEmissionSystemData> systems = new ArrayList<ElectronicEmissionSystemData>();

    public ElectronicEmissionsPdu() {
        this.setPduType((short)23);
        this.setPaddingForEmissionsPdu(0);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.emittingEntityID.getMarshalledSize();
        marshalSize += this.eventID.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        marshalSize += 2;
        for (int idx = 0; idx < this.systems.size(); ++idx) {
            ElectronicEmissionSystemData listElement = this.systems.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setEmittingEntityID(EntityID pEmittingEntityID) {
        this.emittingEntityID = pEmittingEntityID;
    }

    public EntityID getEmittingEntityID() {
        return this.emittingEntityID;
    }

    public void setEventID(EventID pEventID) {
        this.eventID = pEventID;
    }

    public EventID getEventID() {
        return this.eventID;
    }

    public void setStateUpdateIndicator(short pStateUpdateIndicator) {
        this.stateUpdateIndicator = pStateUpdateIndicator;
    }

    public short getStateUpdateIndicator() {
        return this.stateUpdateIndicator;
    }

    public short getNumberOfSystems() {
        return (short)this.systems.size();
    }

    public void setNumberOfSystems(short pNumberOfSystems) {
        this.numberOfSystems = pNumberOfSystems;
    }

    public void setPaddingForEmissionsPdu(int pPaddingForEmissionsPdu) {
        this.paddingForEmissionsPdu = pPaddingForEmissionsPdu;
    }

    public int getPaddingForEmissionsPdu() {
        return this.paddingForEmissionsPdu;
    }

    public void setSystems(List<ElectronicEmissionSystemData> pSystems) {
        this.systems = pSystems;
    }

    public List<ElectronicEmissionSystemData> getSystems() {
        return this.systems;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.emittingEntityID.marshal(buff);
        this.eventID.marshal(buff);
        buff.put((byte)this.stateUpdateIndicator);
        buff.put((byte)this.systems.size());
        buff.putShort((short)this.paddingForEmissionsPdu);
        for (int idx = 0; idx < this.systems.size(); ++idx) {
            ElectronicEmissionSystemData aElectronicEmissionSystemData = this.systems.get(idx);
            aElectronicEmissionSystemData.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.emittingEntityID.unmarshal(buff);
        this.eventID.unmarshal(buff);
        this.stateUpdateIndicator = (short)(buff.get() & 0xFF);
        this.numberOfSystems = (short)(buff.get() & 0xFF);
        this.paddingForEmissionsPdu = buff.getShort() & 0xFFFF;
        for (int idx = 0; idx < this.numberOfSystems; ++idx) {
            ElectronicEmissionSystemData anX = new ElectronicEmissionSystemData();
            anX.unmarshal(buff);
            this.systems.add(anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof ElectronicEmissionsPdu)) {
            return false;
        }
        ElectronicEmissionsPdu rhs = (ElectronicEmissionsPdu)obj;
        if (!this.emittingEntityID.equals(rhs.emittingEntityID)) {
            ivarsEqual = false;
        }
        if (!this.eventID.equals(rhs.eventID)) {
            ivarsEqual = false;
        }
        if (this.stateUpdateIndicator != rhs.stateUpdateIndicator) {
            ivarsEqual = false;
        }
        if (this.numberOfSystems != rhs.numberOfSystems) {
            ivarsEqual = false;
        }
        if (this.paddingForEmissionsPdu != rhs.paddingForEmissionsPdu) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.systems.size(); ++idx) {
            if (this.systems.get(idx).equals(rhs.systems.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

