/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.EntityType;
import edu.nps.moves.dis.Environment;
import edu.nps.moves.dis.SyntheticEnvironmentFamilyPdu;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class EnvironmentalProcessPdu
extends SyntheticEnvironmentFamilyPdu
implements Serializable {
    protected EntityID environementalProcessID = new EntityID();
    protected EntityType environmentType = new EntityType();
    protected short modelType;
    protected short environmentStatus;
    protected short numberOfEnvironmentRecords;
    protected int sequenceNumber;
    protected List<Environment> environmentRecords = new ArrayList<Environment>();

    public EnvironmentalProcessPdu() {
        this.setPduType((short)41);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.environementalProcessID.getMarshalledSize();
        marshalSize += this.environmentType.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        marshalSize += 2;
        for (int idx = 0; idx < this.environmentRecords.size(); ++idx) {
            Environment listElement = this.environmentRecords.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setEnvironementalProcessID(EntityID pEnvironementalProcessID) {
        this.environementalProcessID = pEnvironementalProcessID;
    }

    public EntityID getEnvironementalProcessID() {
        return this.environementalProcessID;
    }

    public void setEnvironmentType(EntityType pEnvironmentType) {
        this.environmentType = pEnvironmentType;
    }

    public EntityType getEnvironmentType() {
        return this.environmentType;
    }

    public void setModelType(short pModelType) {
        this.modelType = pModelType;
    }

    public short getModelType() {
        return this.modelType;
    }

    public void setEnvironmentStatus(short pEnvironmentStatus) {
        this.environmentStatus = pEnvironmentStatus;
    }

    public short getEnvironmentStatus() {
        return this.environmentStatus;
    }

    public short getNumberOfEnvironmentRecords() {
        return (short)this.environmentRecords.size();
    }

    public void setNumberOfEnvironmentRecords(short pNumberOfEnvironmentRecords) {
        this.numberOfEnvironmentRecords = pNumberOfEnvironmentRecords;
    }

    public void setSequenceNumber(int pSequenceNumber) {
        this.sequenceNumber = pSequenceNumber;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setEnvironmentRecords(List<Environment> pEnvironmentRecords) {
        this.environmentRecords = pEnvironmentRecords;
    }

    public List<Environment> getEnvironmentRecords() {
        return this.environmentRecords;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.environementalProcessID.marshal(buff);
        this.environmentType.marshal(buff);
        buff.put((byte)this.modelType);
        buff.put((byte)this.environmentStatus);
        buff.put((byte)this.environmentRecords.size());
        buff.putShort((short)this.sequenceNumber);
        for (int idx = 0; idx < this.environmentRecords.size(); ++idx) {
            Environment aEnvironment = this.environmentRecords.get(idx);
            aEnvironment.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.environementalProcessID.unmarshal(buff);
        this.environmentType.unmarshal(buff);
        this.modelType = (short)(buff.get() & 0xFF);
        this.environmentStatus = (short)(buff.get() & 0xFF);
        this.numberOfEnvironmentRecords = (short)(buff.get() & 0xFF);
        this.sequenceNumber = buff.getShort() & 0xFFFF;
        for (int idx = 0; idx < this.numberOfEnvironmentRecords; ++idx) {
            Environment anX = new Environment();
            anX.unmarshal(buff);
            this.environmentRecords.add(anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof EnvironmentalProcessPdu)) {
            return false;
        }
        EnvironmentalProcessPdu rhs = (EnvironmentalProcessPdu)obj;
        if (!this.environementalProcessID.equals(rhs.environementalProcessID)) {
            ivarsEqual = false;
        }
        if (!this.environmentType.equals(rhs.environmentType)) {
            ivarsEqual = false;
        }
        if (this.modelType != rhs.modelType) {
            ivarsEqual = false;
        }
        if (this.environmentStatus != rhs.environmentStatus) {
            ivarsEqual = false;
        }
        if (this.numberOfEnvironmentRecords != rhs.numberOfEnvironmentRecords) {
            ivarsEqual = false;
        }
        if (this.sequenceNumber != rhs.sequenceNumber) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.environmentRecords.size(); ++idx) {
            if (this.environmentRecords.get(idx).equals(rhs.environmentRecords.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

