/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.GridAxisRecord;
import edu.nps.moves.dis.TwoByteChunk;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class GridAxisRecordRepresentation1
extends GridAxisRecord
implements Serializable {
    protected float fieldScale;
    protected float fieldOffset;
    protected int numberOfValues;
    protected List<TwoByteChunk> dataValues = new ArrayList<TwoByteChunk>();

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 2;
        for (int idx = 0; idx < this.dataValues.size(); ++idx) {
            TwoByteChunk listElement = this.dataValues.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setFieldScale(float pFieldScale) {
        this.fieldScale = pFieldScale;
    }

    public float getFieldScale() {
        return this.fieldScale;
    }

    public void setFieldOffset(float pFieldOffset) {
        this.fieldOffset = pFieldOffset;
    }

    public float getFieldOffset() {
        return this.fieldOffset;
    }

    public int getNumberOfValues() {
        return this.dataValues.size();
    }

    public void setNumberOfValues(int pNumberOfValues) {
        this.numberOfValues = pNumberOfValues;
    }

    public void setDataValues(List<TwoByteChunk> pDataValues) {
        this.dataValues = pDataValues;
    }

    public List<TwoByteChunk> getDataValues() {
        return this.dataValues;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        buff.putFloat(this.fieldScale);
        buff.putFloat(this.fieldOffset);
        buff.putShort((short)this.dataValues.size());
        for (int idx = 0; idx < this.dataValues.size(); ++idx) {
            TwoByteChunk aTwoByteChunk = this.dataValues.get(idx);
            aTwoByteChunk.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.fieldScale = buff.getFloat();
        this.fieldOffset = buff.getFloat();
        this.numberOfValues = buff.getShort() & 0xFFFF;
        for (int idx = 0; idx < this.numberOfValues; ++idx) {
            TwoByteChunk anX = new TwoByteChunk();
            anX.unmarshal(buff);
            this.dataValues.add(anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof GridAxisRecordRepresentation1)) {
            return false;
        }
        GridAxisRecordRepresentation1 rhs = (GridAxisRecordRepresentation1)obj;
        if (this.fieldScale != rhs.fieldScale) {
            ivarsEqual = false;
        }
        if (this.fieldOffset != rhs.fieldOffset) {
            ivarsEqual = false;
        }
        if (this.numberOfValues != rhs.numberOfValues) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.dataValues.size(); ++idx) {
            if (this.dataValues.get(idx).equals(rhs.dataValues.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

