/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.EntityType;
import edu.nps.moves.dis.GridAxisRecord;
import edu.nps.moves.dis.Orientation;
import edu.nps.moves.dis.SyntheticEnvironmentFamilyPdu;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class GriddedDataPdu
extends SyntheticEnvironmentFamilyPdu
implements Serializable {
    protected EntityID environmentalSimulationApplicationID = new EntityID();
    protected int fieldNumber;
    protected int pduNumber;
    protected int pduTotal;
    protected int coordinateSystem;
    protected short numberOfGridAxes;
    protected short constantGrid;
    protected EntityType environmentType = new EntityType();
    protected Orientation orientation = new Orientation();
    protected long sampleTime;
    protected long totalValues;
    protected short vectorDimension;
    protected int padding1;
    protected short padding2;
    protected List<GridAxisRecord> gridDataList = new ArrayList<GridAxisRecord>();

    public GriddedDataPdu() {
        this.setPduType((short)42);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.environmentalSimulationApplicationID.getMarshalledSize();
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 2;
        ++marshalSize;
        ++marshalSize;
        marshalSize += this.environmentType.getMarshalledSize();
        marshalSize += this.orientation.getMarshalledSize();
        marshalSize += 8;
        marshalSize += 4;
        ++marshalSize;
        marshalSize += 2;
        ++marshalSize;
        for (int idx = 0; idx < this.gridDataList.size(); ++idx) {
            GridAxisRecord listElement = this.gridDataList.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setEnvironmentalSimulationApplicationID(EntityID pEnvironmentalSimulationApplicationID) {
        this.environmentalSimulationApplicationID = pEnvironmentalSimulationApplicationID;
    }

    public EntityID getEnvironmentalSimulationApplicationID() {
        return this.environmentalSimulationApplicationID;
    }

    public void setFieldNumber(int pFieldNumber) {
        this.fieldNumber = pFieldNumber;
    }

    public int getFieldNumber() {
        return this.fieldNumber;
    }

    public void setPduNumber(int pPduNumber) {
        this.pduNumber = pPduNumber;
    }

    public int getPduNumber() {
        return this.pduNumber;
    }

    public void setPduTotal(int pPduTotal) {
        this.pduTotal = pPduTotal;
    }

    public int getPduTotal() {
        return this.pduTotal;
    }

    public void setCoordinateSystem(int pCoordinateSystem) {
        this.coordinateSystem = pCoordinateSystem;
    }

    public int getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public short getNumberOfGridAxes() {
        return (short)this.gridDataList.size();
    }

    public void setNumberOfGridAxes(short pNumberOfGridAxes) {
        this.numberOfGridAxes = pNumberOfGridAxes;
    }

    public void setConstantGrid(short pConstantGrid) {
        this.constantGrid = pConstantGrid;
    }

    public short getConstantGrid() {
        return this.constantGrid;
    }

    public void setEnvironmentType(EntityType pEnvironmentType) {
        this.environmentType = pEnvironmentType;
    }

    public EntityType getEnvironmentType() {
        return this.environmentType;
    }

    public void setOrientation(Orientation pOrientation) {
        this.orientation = pOrientation;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setSampleTime(long pSampleTime) {
        this.sampleTime = pSampleTime;
    }

    public long getSampleTime() {
        return this.sampleTime;
    }

    public void setTotalValues(long pTotalValues) {
        this.totalValues = pTotalValues;
    }

    public long getTotalValues() {
        return this.totalValues;
    }

    public void setVectorDimension(short pVectorDimension) {
        this.vectorDimension = pVectorDimension;
    }

    public short getVectorDimension() {
        return this.vectorDimension;
    }

    public void setPadding1(int pPadding1) {
        this.padding1 = pPadding1;
    }

    public int getPadding1() {
        return this.padding1;
    }

    public void setPadding2(short pPadding2) {
        this.padding2 = pPadding2;
    }

    public short getPadding2() {
        return this.padding2;
    }

    public void setGridDataList(List<GridAxisRecord> pGridDataList) {
        this.gridDataList = pGridDataList;
    }

    public List<GridAxisRecord> getGridDataList() {
        return this.gridDataList;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.environmentalSimulationApplicationID.marshal(buff);
        buff.putShort((short)this.fieldNumber);
        buff.putShort((short)this.pduNumber);
        buff.putShort((short)this.pduTotal);
        buff.putShort((short)this.coordinateSystem);
        buff.put((byte)this.gridDataList.size());
        buff.put((byte)this.constantGrid);
        this.environmentType.marshal(buff);
        this.orientation.marshal(buff);
        buff.putLong(this.sampleTime);
        buff.putInt((int)this.totalValues);
        buff.put((byte)this.vectorDimension);
        buff.putShort((short)this.padding1);
        buff.put((byte)this.padding2);
        for (int idx = 0; idx < this.gridDataList.size(); ++idx) {
            GridAxisRecord aGridAxisRecord = this.gridDataList.get(idx);
            aGridAxisRecord.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.environmentalSimulationApplicationID.unmarshal(buff);
        this.fieldNumber = buff.getShort() & 0xFFFF;
        this.pduNumber = buff.getShort() & 0xFFFF;
        this.pduTotal = buff.getShort() & 0xFFFF;
        this.coordinateSystem = buff.getShort() & 0xFFFF;
        this.numberOfGridAxes = (short)(buff.get() & 0xFF);
        this.constantGrid = (short)(buff.get() & 0xFF);
        this.environmentType.unmarshal(buff);
        this.orientation.unmarshal(buff);
        this.sampleTime = buff.getLong();
        this.totalValues = buff.getInt();
        this.vectorDimension = (short)(buff.get() & 0xFF);
        this.padding1 = buff.getShort() & 0xFFFF;
        this.padding2 = (short)(buff.get() & 0xFF);
        for (int idx = 0; idx < this.numberOfGridAxes; ++idx) {
            GridAxisRecord anX = new GridAxisRecord();
            anX.unmarshal(buff);
            this.gridDataList.add(anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof GriddedDataPdu)) {
            return false;
        }
        GriddedDataPdu rhs = (GriddedDataPdu)obj;
        if (!this.environmentalSimulationApplicationID.equals(rhs.environmentalSimulationApplicationID)) {
            ivarsEqual = false;
        }
        if (this.fieldNumber != rhs.fieldNumber) {
            ivarsEqual = false;
        }
        if (this.pduNumber != rhs.pduNumber) {
            ivarsEqual = false;
        }
        if (this.pduTotal != rhs.pduTotal) {
            ivarsEqual = false;
        }
        if (this.coordinateSystem != rhs.coordinateSystem) {
            ivarsEqual = false;
        }
        if (this.numberOfGridAxes != rhs.numberOfGridAxes) {
            ivarsEqual = false;
        }
        if (this.constantGrid != rhs.constantGrid) {
            ivarsEqual = false;
        }
        if (!this.environmentType.equals(rhs.environmentType)) {
            ivarsEqual = false;
        }
        if (!this.orientation.equals(rhs.orientation)) {
            ivarsEqual = false;
        }
        if (this.sampleTime != rhs.sampleTime) {
            ivarsEqual = false;
        }
        if (this.totalValues != rhs.totalValues) {
            ivarsEqual = false;
        }
        if (this.vectorDimension != rhs.vectorDimension) {
            ivarsEqual = false;
        }
        if (this.padding1 != rhs.padding1) {
            ivarsEqual = false;
        }
        if (this.padding2 != rhs.padding2) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.gridDataList.size(); ++idx) {
            if (this.gridDataList.get(idx).equals(rhs.gridDataList.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

