/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.DistributedEmissionsFamilyPdu;
import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.EventID;
import edu.nps.moves.dis.IffAtcNavAidsLayer2Pdu;
import edu.nps.moves.dis.IffFundamentalData;
import edu.nps.moves.dis.SystemID;
import edu.nps.moves.dis.Vector3Float;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class IffAtcNavAidsLayer1Pdu
extends DistributedEmissionsFamilyPdu
implements Serializable {
    private static final int LAYER_PRESENT = 4;
    private static final int LAYER_NOT_PRESENT = 0;
    protected EntityID emittingEntityId = new EntityID();
    protected EventID eventID = new EventID();
    protected Vector3Float location = new Vector3Float();
    protected SystemID systemID = new SystemID();
    protected int pad2;
    protected IffFundamentalData fundamentalData = new IffFundamentalData();
    protected int layer2Value = 0;
    protected IffAtcNavAidsLayer2Pdu layer2 = null;

    public IffAtcNavAidsLayer1Pdu() {
        this.setPduType((short)28);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.emittingEntityId.getMarshalledSize();
        marshalSize += this.eventID.getMarshalledSize();
        marshalSize += this.location.getMarshalledSize();
        marshalSize += this.systemID.getMarshalledSize();
        marshalSize += 2;
        marshalSize += this.fundamentalData.getMarshalledSize();
        if ((this.getLayer2Value() & 4) == 4) {
            marshalSize += this.layer2.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setEmittingEntityId(EntityID pEmittingEntityId) {
        this.emittingEntityId = pEmittingEntityId;
    }

    public EntityID getEmittingEntityId() {
        return this.emittingEntityId;
    }

    public void setEventID(EventID pEventID) {
        this.eventID = pEventID;
    }

    public EventID getEventID() {
        return this.eventID;
    }

    public void setLocation(Vector3Float pLocation) {
        this.location = pLocation;
    }

    public Vector3Float getLocation() {
        return this.location;
    }

    public void setSystemID(SystemID pSystemID) {
        this.systemID = pSystemID;
    }

    public SystemID getSystemID() {
        return this.systemID;
    }

    public void setPad2(int pPad2) {
        this.pad2 = pPad2;
    }

    public int getPad2() {
        return this.pad2;
    }

    public void setFundamentalData(IffFundamentalData pFundamentalData) {
        this.fundamentalData = pFundamentalData;
    }

    public IffFundamentalData getFundamentalData() {
        return this.fundamentalData;
    }

    public void setLayer2Value(int pLayer2Value) {
        this.layer2Value = pLayer2Value << 2;
        short newInformationLayer = (short)(this.getFundamentalData().getInformationLayers() & 0xFB);
        newInformationLayer = (short)(newInformationLayer | this.layer2Value);
        this.getFundamentalData().setInformationLayers(newInformationLayer);
    }

    public int getLayer2Value() {
        this.layer2Value = this.getFundamentalData().getInformationLayers() & 4;
        return this.layer2Value;
    }

    public void setIffAtcNavAidsLayer2(IffAtcNavAidsLayer2Pdu pLayer2) {
        this.layer2 = pLayer2;
        short data = this.getFundamentalData().getInformationLayers();
        data = (short)(data | 4);
        this.getFundamentalData().setInformationLayers(data);
        this.layer2.getLayerHeader().setLayerNumber((short)2);
        this.layer2.getLayerHeader().setLayerSpecificInformaiton((short)0);
    }

    public IffAtcNavAidsLayer2Pdu getIffAtcNavAidsLayer2() {
        return this.layer2;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.emittingEntityId.marshal(buff);
        this.eventID.marshal(buff);
        this.location.marshal(buff);
        this.systemID.marshal(buff);
        buff.putShort((short)this.pad2);
        this.fundamentalData.marshal(buff);
        if ((this.getLayer2Value() & 4) == 4) {
            this.layer2.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.emittingEntityId.unmarshal(buff);
        this.eventID.unmarshal(buff);
        this.location.unmarshal(buff);
        this.systemID.unmarshal(buff);
        this.pad2 = buff.getShort() & 0xFFFF;
        this.fundamentalData.unmarshal(buff);
        if ((this.getLayer2Value() & 4) == 4) {
            this.layer2 = new IffAtcNavAidsLayer2Pdu();
            this.layer2.unmarshal(buff);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof IffAtcNavAidsLayer1Pdu)) {
            return false;
        }
        IffAtcNavAidsLayer1Pdu rhs = (IffAtcNavAidsLayer1Pdu)obj;
        if (!this.emittingEntityId.equals(rhs.emittingEntityId)) {
            ivarsEqual = false;
        }
        if (!this.eventID.equals(rhs.eventID)) {
            ivarsEqual = false;
        }
        if (!this.location.equals(rhs.location)) {
            ivarsEqual = false;
        }
        if (!this.systemID.equals(rhs.systemID)) {
            ivarsEqual = false;
        }
        if (this.pad2 != rhs.pad2) {
            ivarsEqual = false;
        }
        if (!this.fundamentalData.equals(rhs.fundamentalData)) {
            ivarsEqual = false;
        }
        if ((this.getLayer2Value() & 4) == 4 && !this.layer2.equals(rhs.layer2)) {
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

