/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.BeamData;
import edu.nps.moves.dis.FundamentalParameterDataIff;
import edu.nps.moves.dis.IffAtcNavAidsLayer1Pdu;
import edu.nps.moves.dis.LayerHeader;
import edu.nps.moves.dis.SecondaryOperationalData;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class IffAtcNavAidsLayer2Pdu
extends IffAtcNavAidsLayer1Pdu
implements Serializable {
    protected LayerHeader layerHeader = new LayerHeader();
    protected BeamData beamData = new BeamData();
    protected SecondaryOperationalData secondaryOperationalData = new SecondaryOperationalData();
    protected List<FundamentalParameterDataIff> fundamentalIffParameters = new ArrayList<FundamentalParameterDataIff>();

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += this.layerHeader.getMarshalledSize();
        marshalSize += this.beamData.getMarshalledSize();
        marshalSize += this.secondaryOperationalData.getMarshalledSize();
        for (int idx = 0; idx < this.fundamentalIffParameters.size(); ++idx) {
            FundamentalParameterDataIff listElement = this.fundamentalIffParameters.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setLayerHeader(LayerHeader pLayerHeader) {
        this.layerHeader = pLayerHeader;
    }

    public LayerHeader getLayerHeader() {
        return this.layerHeader;
    }

    public void setBeamData(BeamData pBeamData) {
        this.beamData = pBeamData;
    }

    public BeamData getBeamData() {
        return this.beamData;
    }

    public void setSecondaryOperationalData(SecondaryOperationalData pSecondaryOperationalData) {
        this.secondaryOperationalData = pSecondaryOperationalData;
    }

    public SecondaryOperationalData getSecondaryOperationalData() {
        return this.secondaryOperationalData;
    }

    public void setFundamentalIffParameters(List<FundamentalParameterDataIff> pFundamentalIffParameters) {
        this.fundamentalIffParameters = pFundamentalIffParameters;
    }

    public List<FundamentalParameterDataIff> getFundamentalIffParameters() {
        return this.fundamentalIffParameters;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        this.layerHeader.setLength(32 + 24 * this.fundamentalIffParameters.size());
        this.layerHeader.marshal(buff);
        this.beamData.marshal(buff);
        this.secondaryOperationalData.setNumberofFundamentalParameterDataSets(this.fundamentalIffParameters.size());
        this.secondaryOperationalData.marshal(buff);
        for (int idx = 0; idx < this.fundamentalIffParameters.size(); ++idx) {
            FundamentalParameterDataIff aFundamentalParameterDataIff = this.fundamentalIffParameters.get(idx);
            aFundamentalParameterDataIff.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        this.layerHeader.unmarshal(buff);
        this.beamData.unmarshal(buff);
        this.secondaryOperationalData.unmarshal(buff);
        for (int idx = 0; idx < this.secondaryOperationalData.getNumberofFundamentalParameterDataSets(); ++idx) {
            FundamentalParameterDataIff anX = new FundamentalParameterDataIff();
            anX.unmarshal(buff);
            this.fundamentalIffParameters.add(anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof IffAtcNavAidsLayer2Pdu)) {
            return false;
        }
        IffAtcNavAidsLayer2Pdu rhs = (IffAtcNavAidsLayer2Pdu)obj;
        if (!this.layerHeader.equals(rhs.layerHeader)) {
            ivarsEqual = false;
        }
        if (!this.beamData.equals(rhs.beamData)) {
            ivarsEqual = false;
        }
        if (!this.secondaryOperationalData.equals(rhs.secondaryOperationalData)) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.fundamentalIffParameters.size(); ++idx) {
            if (this.fundamentalIffParameters.get(idx).equals(rhs.fundamentalIffParameters.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

