/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.RadioCommunicationsFamilyPdu;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class IntercomSignalPdu
extends RadioCommunicationsFamilyPdu
implements Serializable {
    protected EntityID entityId = new EntityID();
    protected int communicationsDeviceID;
    protected int encodingScheme;
    protected int tdlType;
    protected long sampleRate;
    protected int dataLength;
    protected int samples;
    protected byte[] data = new byte[0];

    public IntercomSignalPdu() {
        this.setPduType((short)31);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.entityId.getMarshalledSize();
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 4;
        marshalSize += 2;
        marshalSize += 2;
        return marshalSize += this.data.length;
    }

    public void setEntityId(EntityID pEntityId) {
        this.entityId = pEntityId;
    }

    public EntityID getEntityId() {
        return this.entityId;
    }

    public void setCommunicationsDeviceID(int pCommunicationsDeviceID) {
        this.communicationsDeviceID = pCommunicationsDeviceID;
    }

    public int getCommunicationsDeviceID() {
        return this.communicationsDeviceID;
    }

    public void setEncodingScheme(int pEncodingScheme) {
        this.encodingScheme = pEncodingScheme;
    }

    public int getEncodingScheme() {
        return this.encodingScheme;
    }

    public void setTdlType(int pTdlType) {
        this.tdlType = pTdlType;
    }

    public int getTdlType() {
        return this.tdlType;
    }

    public void setSampleRate(long pSampleRate) {
        this.sampleRate = pSampleRate;
    }

    public long getSampleRate() {
        return this.sampleRate;
    }

    public int getDataLength() {
        return this.data.length;
    }

    public void setDataLength(int pDataLength) {
        this.dataLength = pDataLength;
    }

    public void setSamples(int pSamples) {
        this.samples = pSamples;
    }

    public int getSamples() {
        return this.samples;
    }

    public void setData(byte[] pData) {
        this.data = pData;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.entityId.marshal(buff);
        buff.putShort((short)this.communicationsDeviceID);
        buff.putShort((short)this.encodingScheme);
        buff.putShort((short)this.tdlType);
        buff.putInt((int)this.sampleRate);
        buff.putShort((short)this.data.length);
        buff.putShort((short)this.samples);
        buff.put(this.data);
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.entityId.unmarshal(buff);
        this.communicationsDeviceID = buff.getShort() & 0xFFFF;
        this.encodingScheme = buff.getShort() & 0xFFFF;
        this.tdlType = buff.getShort() & 0xFFFF;
        this.sampleRate = buff.getInt();
        this.dataLength = buff.getShort() & 0xFFFF;
        this.samples = buff.getShort() & 0xFFFF;
        this.data = new byte[this.dataLength];
        buff.get(this.data);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof IntercomSignalPdu)) {
            return false;
        }
        IntercomSignalPdu rhs = (IntercomSignalPdu)obj;
        if (!this.entityId.equals(rhs.entityId)) {
            ivarsEqual = false;
        }
        if (this.communicationsDeviceID != rhs.communicationsDeviceID) {
            ivarsEqual = false;
        }
        if (this.encodingScheme != rhs.encodingScheme) {
            ivarsEqual = false;
        }
        if (this.tdlType != rhs.tdlType) {
            ivarsEqual = false;
        }
        if (this.sampleRate != rhs.sampleRate) {
            ivarsEqual = false;
        }
        if (this.dataLength != rhs.dataLength) {
            ivarsEqual = false;
        }
        if (this.samples != rhs.samples) {
            ivarsEqual = false;
        }
        if (!Arrays.equals(this.data, rhs.data)) {
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

