/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.EntityManagementFamilyPdu;
import edu.nps.moves.dis.VariableDatum;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class IsGroupOfPdu
extends EntityManagementFamilyPdu
implements Serializable {
    protected EntityID groupEntityID = new EntityID();
    protected short groupedEntityCategory;
    protected short numberOfGroupedEntities;
    protected long pad2;
    protected double latitude;
    protected double longitude;
    protected List<VariableDatum> groupedEntityDescriptions = new ArrayList<VariableDatum>();

    public IsGroupOfPdu() {
        this.setPduType((short)34);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.groupEntityID.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        marshalSize += 4;
        marshalSize += 8;
        marshalSize += 8;
        for (int idx = 0; idx < this.groupedEntityDescriptions.size(); ++idx) {
            VariableDatum listElement = this.groupedEntityDescriptions.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setGroupEntityID(EntityID pGroupEntityID) {
        this.groupEntityID = pGroupEntityID;
    }

    public EntityID getGroupEntityID() {
        return this.groupEntityID;
    }

    public void setGroupedEntityCategory(short pGroupedEntityCategory) {
        this.groupedEntityCategory = pGroupedEntityCategory;
    }

    public short getGroupedEntityCategory() {
        return this.groupedEntityCategory;
    }

    public short getNumberOfGroupedEntities() {
        return (short)this.groupedEntityDescriptions.size();
    }

    public void setNumberOfGroupedEntities(short pNumberOfGroupedEntities) {
        this.numberOfGroupedEntities = pNumberOfGroupedEntities;
    }

    public void setPad2(long pPad2) {
        this.pad2 = pPad2;
    }

    public long getPad2() {
        return this.pad2;
    }

    public void setLatitude(double pLatitude) {
        this.latitude = pLatitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLongitude(double pLongitude) {
        this.longitude = pLongitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setGroupedEntityDescriptions(List<VariableDatum> pGroupedEntityDescriptions) {
        this.groupedEntityDescriptions = pGroupedEntityDescriptions;
    }

    public List<VariableDatum> getGroupedEntityDescriptions() {
        return this.groupedEntityDescriptions;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.groupEntityID.marshal(buff);
        buff.put((byte)this.groupedEntityCategory);
        buff.put((byte)this.groupedEntityDescriptions.size());
        buff.putInt((int)this.pad2);
        buff.putDouble(this.latitude);
        buff.putDouble(this.longitude);
        for (int idx = 0; idx < this.groupedEntityDescriptions.size(); ++idx) {
            VariableDatum aVariableDatum = this.groupedEntityDescriptions.get(idx);
            aVariableDatum.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.groupEntityID.unmarshal(buff);
        this.groupedEntityCategory = (short)(buff.get() & 0xFF);
        this.numberOfGroupedEntities = (short)(buff.get() & 0xFF);
        this.pad2 = buff.getInt();
        this.latitude = buff.getDouble();
        this.longitude = buff.getDouble();
        for (int idx = 0; idx < this.numberOfGroupedEntities; ++idx) {
            VariableDatum anX = new VariableDatum();
            anX.unmarshal(buff);
            this.groupedEntityDescriptions.add(anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof IsGroupOfPdu)) {
            return false;
        }
        IsGroupOfPdu rhs = (IsGroupOfPdu)obj;
        if (!this.groupEntityID.equals(rhs.groupEntityID)) {
            ivarsEqual = false;
        }
        if (this.groupedEntityCategory != rhs.groupedEntityCategory) {
            ivarsEqual = false;
        }
        if (this.numberOfGroupedEntities != rhs.numberOfGroupedEntities) {
            ivarsEqual = false;
        }
        if (this.pad2 != rhs.pad2) {
            ivarsEqual = false;
        }
        if (this.latitude != rhs.latitude) {
            ivarsEqual = false;
        }
        if (this.longitude != rhs.longitude) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.groupedEntityDescriptions.size(); ++idx) {
            if (this.groupedEntityDescriptions.get(idx).equals(rhs.groupedEntityDescriptions.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

