/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.LinearSegmentParameter;
import edu.nps.moves.dis.ObjectType;
import edu.nps.moves.dis.SimulationAddress;
import edu.nps.moves.dis.SyntheticEnvironmentFamilyPdu;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class LinearObjectStatePdu
extends SyntheticEnvironmentFamilyPdu
implements Serializable {
    protected EntityID objectID = new EntityID();
    protected EntityID referencedObjectID = new EntityID();
    protected int updateNumber;
    protected short forceID;
    protected short numberOfSegments;
    protected SimulationAddress requesterID = new SimulationAddress();
    protected SimulationAddress receivingID = new SimulationAddress();
    protected ObjectType objectType = new ObjectType();
    protected List<LinearSegmentParameter> linearSegmentParameters = new ArrayList<LinearSegmentParameter>();

    public LinearObjectStatePdu() {
        this.setPduType((short)44);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.objectID.getMarshalledSize();
        marshalSize += this.referencedObjectID.getMarshalledSize();
        marshalSize += 2;
        ++marshalSize;
        ++marshalSize;
        marshalSize += this.requesterID.getMarshalledSize();
        marshalSize += this.receivingID.getMarshalledSize();
        marshalSize += this.objectType.getMarshalledSize();
        for (int idx = 0; idx < this.linearSegmentParameters.size(); ++idx) {
            LinearSegmentParameter listElement = this.linearSegmentParameters.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setObjectID(EntityID pObjectID) {
        this.objectID = pObjectID;
    }

    public EntityID getObjectID() {
        return this.objectID;
    }

    public void setReferencedObjectID(EntityID pReferencedObjectID) {
        this.referencedObjectID = pReferencedObjectID;
    }

    public EntityID getReferencedObjectID() {
        return this.referencedObjectID;
    }

    public void setUpdateNumber(int pUpdateNumber) {
        this.updateNumber = pUpdateNumber;
    }

    public int getUpdateNumber() {
        return this.updateNumber;
    }

    public void setForceID(short pForceID) {
        this.forceID = pForceID;
    }

    public short getForceID() {
        return this.forceID;
    }

    public short getNumberOfSegments() {
        return (short)this.linearSegmentParameters.size();
    }

    public void setNumberOfSegments(short pNumberOfSegments) {
        this.numberOfSegments = pNumberOfSegments;
    }

    public void setRequesterID(SimulationAddress pRequesterID) {
        this.requesterID = pRequesterID;
    }

    public SimulationAddress getRequesterID() {
        return this.requesterID;
    }

    public void setReceivingID(SimulationAddress pReceivingID) {
        this.receivingID = pReceivingID;
    }

    public SimulationAddress getReceivingID() {
        return this.receivingID;
    }

    public void setObjectType(ObjectType pObjectType) {
        this.objectType = pObjectType;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public void setLinearSegmentParameters(List<LinearSegmentParameter> pLinearSegmentParameters) {
        this.linearSegmentParameters = pLinearSegmentParameters;
    }

    public List<LinearSegmentParameter> getLinearSegmentParameters() {
        return this.linearSegmentParameters;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.objectID.marshal(buff);
        this.referencedObjectID.marshal(buff);
        buff.putShort((short)this.updateNumber);
        buff.put((byte)this.forceID);
        buff.put((byte)this.linearSegmentParameters.size());
        this.requesterID.marshal(buff);
        this.receivingID.marshal(buff);
        this.objectType.marshal(buff);
        for (int idx = 0; idx < this.linearSegmentParameters.size(); ++idx) {
            LinearSegmentParameter aLinearSegmentParameter = this.linearSegmentParameters.get(idx);
            aLinearSegmentParameter.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.objectID.unmarshal(buff);
        this.referencedObjectID.unmarshal(buff);
        this.updateNumber = buff.getShort() & 0xFFFF;
        this.forceID = (short)(buff.get() & 0xFF);
        this.numberOfSegments = (short)(buff.get() & 0xFF);
        this.requesterID.unmarshal(buff);
        this.receivingID.unmarshal(buff);
        this.objectType.unmarshal(buff);
        for (int idx = 0; idx < this.numberOfSegments; ++idx) {
            LinearSegmentParameter anX = new LinearSegmentParameter();
            anX.unmarshal(buff);
            this.linearSegmentParameters.add(anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof LinearObjectStatePdu)) {
            return false;
        }
        LinearObjectStatePdu rhs = (LinearObjectStatePdu)obj;
        if (!this.objectID.equals(rhs.objectID)) {
            ivarsEqual = false;
        }
        if (!this.referencedObjectID.equals(rhs.referencedObjectID)) {
            ivarsEqual = false;
        }
        if (this.updateNumber != rhs.updateNumber) {
            ivarsEqual = false;
        }
        if (this.forceID != rhs.forceID) {
            ivarsEqual = false;
        }
        if (this.numberOfSegments != rhs.numberOfSegments) {
            ivarsEqual = false;
        }
        if (!this.requesterID.equals(rhs.requesterID)) {
            ivarsEqual = false;
        }
        if (!this.receivingID.equals(rhs.receivingID)) {
            ivarsEqual = false;
        }
        if (!this.objectType.equals(rhs.objectType)) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.linearSegmentParameters.size(); ++idx) {
            if (this.linearSegmentParameters.get(idx).equals(rhs.linearSegmentParameters.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

