/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.EntityType;
import edu.nps.moves.dis.MinefieldFamilyPdu;
import edu.nps.moves.dis.Point;
import edu.nps.moves.dis.TwoByteChunk;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class MinefieldQueryPdu
extends MinefieldFamilyPdu
implements Serializable {
    protected EntityID minefieldID = new EntityID();
    protected EntityID requestingEntityID = new EntityID();
    protected short requestID;
    protected short numberOfPerimeterPoints;
    protected short pad2;
    protected short numberOfSensorTypes;
    protected long dataFilter;
    protected EntityType requestedMineType = new EntityType();
    protected List<Point> requestedPerimeterPoints = new ArrayList<Point>();
    protected List<TwoByteChunk> sensorTypes = new ArrayList<TwoByteChunk>();

    public MinefieldQueryPdu() {
        this.setPduType((short)38);
    }

    @Override
    public int getMarshalledSize() {
        Serializable listElement;
        int idx;
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.minefieldID.getMarshalledSize();
        marshalSize += this.requestingEntityID.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        marshalSize += 4;
        marshalSize += this.requestedMineType.getMarshalledSize();
        for (idx = 0; idx < this.requestedPerimeterPoints.size(); ++idx) {
            listElement = this.requestedPerimeterPoints.get(idx);
            marshalSize += ((Point)listElement).getMarshalledSize();
        }
        for (idx = 0; idx < this.sensorTypes.size(); ++idx) {
            listElement = this.sensorTypes.get(idx);
            marshalSize += ((TwoByteChunk)listElement).getMarshalledSize();
        }
        return marshalSize;
    }

    public void setMinefieldID(EntityID pMinefieldID) {
        this.minefieldID = pMinefieldID;
    }

    public EntityID getMinefieldID() {
        return this.minefieldID;
    }

    public void setRequestingEntityID(EntityID pRequestingEntityID) {
        this.requestingEntityID = pRequestingEntityID;
    }

    public EntityID getRequestingEntityID() {
        return this.requestingEntityID;
    }

    public void setRequestID(short pRequestID) {
        this.requestID = pRequestID;
    }

    public short getRequestID() {
        return this.requestID;
    }

    public short getNumberOfPerimeterPoints() {
        return (short)this.requestedPerimeterPoints.size();
    }

    public void setNumberOfPerimeterPoints(short pNumberOfPerimeterPoints) {
        this.numberOfPerimeterPoints = pNumberOfPerimeterPoints;
    }

    public void setPad2(short pPad2) {
        this.pad2 = pPad2;
    }

    public short getPad2() {
        return this.pad2;
    }

    public short getNumberOfSensorTypes() {
        return (short)this.sensorTypes.size();
    }

    public void setNumberOfSensorTypes(short pNumberOfSensorTypes) {
        this.numberOfSensorTypes = pNumberOfSensorTypes;
    }

    public void setDataFilter(long pDataFilter) {
        this.dataFilter = pDataFilter;
    }

    public long getDataFilter() {
        return this.dataFilter;
    }

    public void setRequestedMineType(EntityType pRequestedMineType) {
        this.requestedMineType = pRequestedMineType;
    }

    public EntityType getRequestedMineType() {
        return this.requestedMineType;
    }

    public void setRequestedPerimeterPoints(List<Point> pRequestedPerimeterPoints) {
        this.requestedPerimeterPoints = pRequestedPerimeterPoints;
    }

    public List<Point> getRequestedPerimeterPoints() {
        return this.requestedPerimeterPoints;
    }

    public void setSensorTypes(List<TwoByteChunk> pSensorTypes) {
        this.sensorTypes = pSensorTypes;
    }

    public List<TwoByteChunk> getSensorTypes() {
        return this.sensorTypes;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        int idx;
        super.marshal(buff);
        this.minefieldID.marshal(buff);
        this.requestingEntityID.marshal(buff);
        buff.put((byte)this.requestID);
        buff.put((byte)this.requestedPerimeterPoints.size());
        buff.put((byte)this.pad2);
        buff.put((byte)this.sensorTypes.size());
        buff.putInt((int)this.dataFilter);
        this.requestedMineType.marshal(buff);
        for (idx = 0; idx < this.requestedPerimeterPoints.size(); ++idx) {
            Point aPoint = this.requestedPerimeterPoints.get(idx);
            aPoint.marshal(buff);
        }
        for (idx = 0; idx < this.sensorTypes.size(); ++idx) {
            TwoByteChunk aTwoByteChunk = this.sensorTypes.get(idx);
            aTwoByteChunk.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        Serializable anX;
        int idx;
        super.unmarshal(buff);
        this.minefieldID.unmarshal(buff);
        this.requestingEntityID.unmarshal(buff);
        this.requestID = (short)(buff.get() & 0xFF);
        this.numberOfPerimeterPoints = (short)(buff.get() & 0xFF);
        this.pad2 = (short)(buff.get() & 0xFF);
        this.numberOfSensorTypes = (short)(buff.get() & 0xFF);
        this.dataFilter = buff.getInt();
        this.requestedMineType.unmarshal(buff);
        for (idx = 0; idx < this.numberOfPerimeterPoints; ++idx) {
            anX = new Point();
            ((Point)anX).unmarshal(buff);
            this.requestedPerimeterPoints.add((Point)anX);
        }
        for (idx = 0; idx < this.numberOfSensorTypes; ++idx) {
            anX = new TwoByteChunk();
            ((TwoByteChunk)anX).unmarshal(buff);
            this.sensorTypes.add((TwoByteChunk)anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        int idx;
        boolean ivarsEqual = true;
        if (!(obj instanceof MinefieldQueryPdu)) {
            return false;
        }
        MinefieldQueryPdu rhs = (MinefieldQueryPdu)obj;
        if (!this.minefieldID.equals(rhs.minefieldID)) {
            ivarsEqual = false;
        }
        if (!this.requestingEntityID.equals(rhs.requestingEntityID)) {
            ivarsEqual = false;
        }
        if (this.requestID != rhs.requestID) {
            ivarsEqual = false;
        }
        if (this.numberOfPerimeterPoints != rhs.numberOfPerimeterPoints) {
            ivarsEqual = false;
        }
        if (this.pad2 != rhs.pad2) {
            ivarsEqual = false;
        }
        if (this.numberOfSensorTypes != rhs.numberOfSensorTypes) {
            ivarsEqual = false;
        }
        if (this.dataFilter != rhs.dataFilter) {
            ivarsEqual = false;
        }
        if (!this.requestedMineType.equals(rhs.requestedMineType)) {
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.requestedPerimeterPoints.size(); ++idx) {
            if (this.requestedPerimeterPoints.get(idx).equals(rhs.requestedPerimeterPoints.get(idx))) continue;
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.sensorTypes.size(); ++idx) {
            if (this.sensorTypes.get(idx).equals(rhs.sensorTypes.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

