/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.FourByteChunk;
import edu.nps.moves.dis.SimulationManagementWithReliabilityFamilyPdu;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class RecordQueryReliablePdu
extends SimulationManagementWithReliabilityFamilyPdu
implements Serializable {
    protected long requestID;
    protected short requiredReliabilityService;
    protected int pad1;
    protected short pad2;
    protected int eventType;
    protected long time;
    protected long numberOfRecords;
    protected List<FourByteChunk> recordIDs = new ArrayList<FourByteChunk>();

    public RecordQueryReliablePdu() {
        this.setPduType((short)65);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += 4;
        ++marshalSize;
        marshalSize += 2;
        ++marshalSize;
        marshalSize += 2;
        marshalSize += 4;
        marshalSize += 4;
        for (int idx = 0; idx < this.recordIDs.size(); ++idx) {
            FourByteChunk listElement = this.recordIDs.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setRequestID(long pRequestID) {
        this.requestID = pRequestID;
    }

    public long getRequestID() {
        return this.requestID;
    }

    public void setRequiredReliabilityService(short pRequiredReliabilityService) {
        this.requiredReliabilityService = pRequiredReliabilityService;
    }

    public short getRequiredReliabilityService() {
        return this.requiredReliabilityService;
    }

    public void setPad1(int pPad1) {
        this.pad1 = pPad1;
    }

    public int getPad1() {
        return this.pad1;
    }

    public void setPad2(short pPad2) {
        this.pad2 = pPad2;
    }

    public short getPad2() {
        return this.pad2;
    }

    public void setEventType(int pEventType) {
        this.eventType = pEventType;
    }

    public int getEventType() {
        return this.eventType;
    }

    public void setTime(long pTime) {
        this.time = pTime;
    }

    public long getTime() {
        return this.time;
    }

    public long getNumberOfRecords() {
        return this.recordIDs.size();
    }

    public void setNumberOfRecords(long pNumberOfRecords) {
        this.numberOfRecords = pNumberOfRecords;
    }

    public void setRecordIDs(List<FourByteChunk> pRecordIDs) {
        this.recordIDs = pRecordIDs;
    }

    public List<FourByteChunk> getRecordIDs() {
        return this.recordIDs;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        buff.putInt((int)this.requestID);
        buff.put((byte)this.requiredReliabilityService);
        buff.putShort((short)this.pad1);
        buff.put((byte)this.pad2);
        buff.putShort((short)this.eventType);
        buff.putInt((int)this.time);
        buff.putInt(this.recordIDs.size());
        for (int idx = 0; idx < this.recordIDs.size(); ++idx) {
            FourByteChunk aFourByteChunk = this.recordIDs.get(idx);
            aFourByteChunk.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.requestID = buff.getInt();
        this.requiredReliabilityService = (short)(buff.get() & 0xFF);
        this.pad1 = buff.getShort() & 0xFFFF;
        this.pad2 = (short)(buff.get() & 0xFF);
        this.eventType = buff.getShort() & 0xFFFF;
        this.time = buff.getInt();
        this.numberOfRecords = buff.getInt();
        int idx = 0;
        while ((long)idx < this.numberOfRecords) {
            FourByteChunk anX = new FourByteChunk();
            anX.unmarshal(buff);
            this.recordIDs.add(anX);
            ++idx;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof RecordQueryReliablePdu)) {
            return false;
        }
        RecordQueryReliablePdu rhs = (RecordQueryReliablePdu)obj;
        if (this.requestID != rhs.requestID) {
            ivarsEqual = false;
        }
        if (this.requiredReliabilityService != rhs.requiredReliabilityService) {
            ivarsEqual = false;
        }
        if (this.pad1 != rhs.pad1) {
            ivarsEqual = false;
        }
        if (this.pad2 != rhs.pad2) {
            ivarsEqual = false;
        }
        if (this.eventType != rhs.eventType) {
            ivarsEqual = false;
        }
        if (this.time != rhs.time) {
            ivarsEqual = false;
        }
        if (this.numberOfRecords != rhs.numberOfRecords) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.recordIDs.size(); ++idx) {
            if (this.recordIDs.get(idx).equals(rhs.recordIDs.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

