/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.LogisticsFamilyPdu;
import edu.nps.moves.dis.SupplyQuantity;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ServiceRequestPdu
extends LogisticsFamilyPdu
implements Serializable {
    protected EntityID requestingEntityID = new EntityID();
    protected EntityID servicingEntityID = new EntityID();
    protected short serviceTypeRequested;
    protected short numberOfSupplyTypes;
    protected short serviceRequestPadding = 0;
    protected List<SupplyQuantity> supplies = new ArrayList<SupplyQuantity>();

    public ServiceRequestPdu() {
        this.setPduType((short)5);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.requestingEntityID.getMarshalledSize();
        marshalSize += this.servicingEntityID.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        marshalSize += 2;
        for (int idx = 0; idx < this.supplies.size(); ++idx) {
            SupplyQuantity listElement = this.supplies.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setRequestingEntityID(EntityID pRequestingEntityID) {
        this.requestingEntityID = pRequestingEntityID;
    }

    public EntityID getRequestingEntityID() {
        return this.requestingEntityID;
    }

    public void setServicingEntityID(EntityID pServicingEntityID) {
        this.servicingEntityID = pServicingEntityID;
    }

    public EntityID getServicingEntityID() {
        return this.servicingEntityID;
    }

    public void setServiceTypeRequested(short pServiceTypeRequested) {
        this.serviceTypeRequested = pServiceTypeRequested;
    }

    public short getServiceTypeRequested() {
        return this.serviceTypeRequested;
    }

    public short getNumberOfSupplyTypes() {
        return (short)this.supplies.size();
    }

    public void setNumberOfSupplyTypes(short pNumberOfSupplyTypes) {
        this.numberOfSupplyTypes = pNumberOfSupplyTypes;
    }

    public void setServiceRequestPadding(short pServiceRequestPadding) {
        this.serviceRequestPadding = pServiceRequestPadding;
    }

    public short getServiceRequestPadding() {
        return this.serviceRequestPadding;
    }

    public void setSupplies(List<SupplyQuantity> pSupplies) {
        this.supplies = pSupplies;
    }

    public List<SupplyQuantity> getSupplies() {
        return this.supplies;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.requestingEntityID.marshal(buff);
        this.servicingEntityID.marshal(buff);
        buff.put((byte)this.serviceTypeRequested);
        buff.put((byte)this.supplies.size());
        buff.putShort(this.serviceRequestPadding);
        for (int idx = 0; idx < this.supplies.size(); ++idx) {
            SupplyQuantity aSupplyQuantity = this.supplies.get(idx);
            aSupplyQuantity.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.requestingEntityID.unmarshal(buff);
        this.servicingEntityID.unmarshal(buff);
        this.serviceTypeRequested = (short)(buff.get() & 0xFF);
        this.numberOfSupplyTypes = (short)(buff.get() & 0xFF);
        this.serviceRequestPadding = buff.getShort();
        for (int idx = 0; idx < this.numberOfSupplyTypes; ++idx) {
            SupplyQuantity anX = new SupplyQuantity();
            anX.unmarshal(buff);
            this.supplies.add(anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof ServiceRequestPdu)) {
            return false;
        }
        ServiceRequestPdu rhs = (ServiceRequestPdu)obj;
        if (!this.requestingEntityID.equals(rhs.requestingEntityID)) {
            ivarsEqual = false;
        }
        if (!this.servicingEntityID.equals(rhs.servicingEntityID)) {
            ivarsEqual = false;
        }
        if (this.serviceTypeRequested != rhs.serviceTypeRequested) {
            ivarsEqual = false;
        }
        if (this.numberOfSupplyTypes != rhs.numberOfSupplyTypes) {
            ivarsEqual = false;
        }
        if (this.serviceRequestPadding != rhs.serviceRequestPadding) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.supplies.size(); ++idx) {
            if (this.supplies.get(idx).equals(rhs.supplies.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

