/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.FixedDatum;
import edu.nps.moves.dis.SimulationManagementFamilyPdu;
import edu.nps.moves.dis.VariableDatum;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class SetDataPdu
extends SimulationManagementFamilyPdu
implements Serializable {
    protected long requestID;
    protected long padding1 = 0L;
    protected long numberOfFixedDatumRecords;
    protected long numberOfVariableDatumRecords;
    protected List<FixedDatum> fixedDatums = new ArrayList<FixedDatum>();
    protected List<VariableDatum> variableDatums = new ArrayList<VariableDatum>();

    public SetDataPdu() {
        this.setPduType((short)19);
    }

    @Override
    public int getMarshalledSize() {
        Serializable listElement;
        int idx;
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        for (idx = 0; idx < this.fixedDatums.size(); ++idx) {
            listElement = this.fixedDatums.get(idx);
            marshalSize += ((FixedDatum)listElement).getMarshalledSize();
        }
        for (idx = 0; idx < this.variableDatums.size(); ++idx) {
            listElement = this.variableDatums.get(idx);
            marshalSize += ((VariableDatum)listElement).getMarshalledSize();
        }
        return marshalSize;
    }

    public void setRequestID(long pRequestID) {
        this.requestID = pRequestID;
    }

    public long getRequestID() {
        return this.requestID;
    }

    public void setPadding1(long pPadding1) {
        this.padding1 = pPadding1;
    }

    public long getPadding1() {
        return this.padding1;
    }

    public long getNumberOfFixedDatumRecords() {
        return this.fixedDatums.size();
    }

    public void setNumberOfFixedDatumRecords(long pNumberOfFixedDatumRecords) {
        this.numberOfFixedDatumRecords = pNumberOfFixedDatumRecords;
    }

    public long getNumberOfVariableDatumRecords() {
        return this.variableDatums.size();
    }

    public void setNumberOfVariableDatumRecords(long pNumberOfVariableDatumRecords) {
        this.numberOfVariableDatumRecords = pNumberOfVariableDatumRecords;
    }

    public void setFixedDatums(List<FixedDatum> pFixedDatums) {
        this.fixedDatums = pFixedDatums;
    }

    public List<FixedDatum> getFixedDatums() {
        return this.fixedDatums;
    }

    public void setVariableDatums(List<VariableDatum> pVariableDatums) {
        this.variableDatums = pVariableDatums;
    }

    public List<VariableDatum> getVariableDatums() {
        return this.variableDatums;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        int idx;
        super.marshal(buff);
        buff.putInt((int)this.requestID);
        buff.putInt((int)this.padding1);
        buff.putInt(this.fixedDatums.size());
        buff.putInt(this.variableDatums.size());
        for (idx = 0; idx < this.fixedDatums.size(); ++idx) {
            FixedDatum fd = this.fixedDatums.get(idx);
            fd.marshal(buff);
        }
        for (idx = 0; idx < this.variableDatums.size(); ++idx) {
            VariableDatum vd = this.variableDatums.get(idx);
            vd.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.requestID = buff.getInt();
        this.padding1 = buff.getInt();
        this.numberOfFixedDatumRecords = buff.getInt();
        this.numberOfVariableDatumRecords = buff.getInt();
        int idx = 0;
        while ((long)idx < this.numberOfFixedDatumRecords) {
            FixedDatum fd = new FixedDatum();
            fd.unmarshal(buff);
            this.fixedDatums.add(fd);
            ++idx;
        }
        idx = 0;
        while ((long)idx < this.numberOfVariableDatumRecords) {
            VariableDatum vd = new VariableDatum();
            vd.unmarshal(buff);
            this.variableDatums.add(vd);
            ++idx;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        int idx;
        boolean ivarsEqual = true;
        if (!(obj instanceof SetDataPdu)) {
            return false;
        }
        SetDataPdu rhs = (SetDataPdu)obj;
        if (this.requestID != rhs.requestID) {
            ivarsEqual = false;
        }
        if (this.padding1 != rhs.padding1) {
            ivarsEqual = false;
        }
        if (this.numberOfFixedDatumRecords != rhs.numberOfFixedDatumRecords) {
            ivarsEqual = false;
        }
        if (this.numberOfVariableDatumRecords != rhs.numberOfVariableDatumRecords) {
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.fixedDatums.size(); ++idx) {
            if (this.fixedDatums.get(idx).equals(rhs.fixedDatums.get(idx))) continue;
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.variableDatums.size(); ++idx) {
            if (this.variableDatums.get(idx).equals(rhs.variableDatums.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

