/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.RecordSet;
import edu.nps.moves.dis.SimulationManagementWithReliabilityFamilyPdu;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class SetRecordReliablePdu
extends SimulationManagementWithReliabilityFamilyPdu
implements Serializable {
    protected long requestID;
    protected short requiredReliabilityService;
    protected int pad1;
    protected short pad2;
    protected long numberOfRecordSets;
    protected List<RecordSet> recordSets = new ArrayList<RecordSet>();

    public SetRecordReliablePdu() {
        this.setPduType((short)64);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += 4;
        ++marshalSize;
        marshalSize += 2;
        ++marshalSize;
        marshalSize += 4;
        for (int idx = 0; idx < this.recordSets.size(); ++idx) {
            RecordSet listElement = this.recordSets.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setRequestID(long pRequestID) {
        this.requestID = pRequestID;
    }

    public long getRequestID() {
        return this.requestID;
    }

    public void setRequiredReliabilityService(short pRequiredReliabilityService) {
        this.requiredReliabilityService = pRequiredReliabilityService;
    }

    public short getRequiredReliabilityService() {
        return this.requiredReliabilityService;
    }

    public void setPad1(int pPad1) {
        this.pad1 = pPad1;
    }

    public int getPad1() {
        return this.pad1;
    }

    public void setPad2(short pPad2) {
        this.pad2 = pPad2;
    }

    public short getPad2() {
        return this.pad2;
    }

    public long getNumberOfRecordSets() {
        return this.recordSets.size();
    }

    public void setNumberOfRecordSets(long pNumberOfRecordSets) {
        this.numberOfRecordSets = pNumberOfRecordSets;
    }

    public void setRecordSets(List<RecordSet> pRecordSets) {
        this.recordSets = pRecordSets;
    }

    public List<RecordSet> getRecordSets() {
        return this.recordSets;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        buff.putInt((int)this.requestID);
        buff.put((byte)this.requiredReliabilityService);
        buff.putShort((short)this.pad1);
        buff.put((byte)this.pad2);
        buff.putInt(this.recordSets.size());
        for (int idx = 0; idx < this.recordSets.size(); ++idx) {
            RecordSet aRecordSet = this.recordSets.get(idx);
            aRecordSet.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.requestID = buff.getInt();
        this.requiredReliabilityService = (short)(buff.get() & 0xFF);
        this.pad1 = buff.getShort() & 0xFFFF;
        this.pad2 = (short)(buff.get() & 0xFF);
        this.numberOfRecordSets = buff.getInt();
        int idx = 0;
        while ((long)idx < this.numberOfRecordSets) {
            RecordSet anX = new RecordSet();
            anX.unmarshal(buff);
            this.recordSets.add(anX);
            ++idx;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof SetRecordReliablePdu)) {
            return false;
        }
        SetRecordReliablePdu rhs = (SetRecordReliablePdu)obj;
        if (this.requestID != rhs.requestID) {
            ivarsEqual = false;
        }
        if (this.requiredReliabilityService != rhs.requiredReliabilityService) {
            ivarsEqual = false;
        }
        if (this.pad1 != rhs.pad1) {
            ivarsEqual = false;
        }
        if (this.pad2 != rhs.pad2) {
            ivarsEqual = false;
        }
        if (this.numberOfRecordSets != rhs.numberOfRecordSets) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.recordSets.size(); ++idx) {
            if (this.recordSets.get(idx).equals(rhs.recordSets.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

