/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.FourByteChunk;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class SphericalHarmonicAntennaPattern
implements Serializable {
    protected byte harmonicOrder;
    protected List<FourByteChunk> coefficients = new ArrayList<FourByteChunk>();
    protected short referenceSystem;

    public int getMarshalledSize() {
        int marshalSize = 0;
        ++marshalSize;
        for (int idx = 0; idx < this.coefficients.size(); ++idx) {
            FourByteChunk listElement = this.coefficients.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return ++marshalSize;
    }

    public void setHarmonicOrder(byte pHarmonicOrder) {
        this.harmonicOrder = pHarmonicOrder;
    }

    public byte getHarmonicOrder() {
        return this.harmonicOrder;
    }

    public void setCoefficientsList(List<FourByteChunk> pCoefficients) {
        this.coefficients = pCoefficients;
    }

    public List<FourByteChunk> getCoefficientsList() {
        return this.coefficients;
    }

    public void setReferenceSystem(short pReferenceSystem) {
        this.referenceSystem = pReferenceSystem;
    }

    public short getReferenceSystem() {
        return this.referenceSystem;
    }

    public void marshal(ByteBuffer buff) {
        buff.put(this.harmonicOrder);
        for (int idx = 0; idx < this.coefficients.size(); ++idx) {
            FourByteChunk aFourByteChunk = this.coefficients.get(idx);
            aFourByteChunk.marshal(buff);
        }
        buff.put((byte)this.referenceSystem);
    }

    public void unmarshal(ByteBuffer buff) {
        this.harmonicOrder = buff.get();
        int coeffientCount = this.harmonicOrder * this.harmonicOrder + 2 * this.harmonicOrder + 1;
        for (int idx = 0; idx < coeffientCount; ++idx) {
            FourByteChunk anX = new FourByteChunk();
            anX.unmarshal(buff);
            this.coefficients.add(anX);
        }
        this.referenceSystem = (short)(buff.get() & 0xFF);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof SphericalHarmonicAntennaPattern)) {
            return false;
        }
        SphericalHarmonicAntennaPattern rhs = (SphericalHarmonicAntennaPattern)obj;
        if (this.harmonicOrder != rhs.harmonicOrder) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.coefficients.size(); ++idx) {
            if (this.coefficients.get(idx).equals(rhs.coefficients.get(idx))) continue;
            ivarsEqual = false;
        }
        if (this.referenceSystem != rhs.referenceSystem) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

