/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.EntityManagementFamilyPdu;
import edu.nps.moves.dis.RecordSet;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class TransferControlRequestPdu
extends EntityManagementFamilyPdu
implements Serializable {
    protected EntityID orginatingEntityID = new EntityID();
    protected EntityID recevingEntityID = new EntityID();
    protected long requestID;
    protected short requiredReliabilityService;
    protected short tranferType;
    protected EntityID transferEntityID = new EntityID();
    protected short numberOfRecordSets;
    protected List<RecordSet> recordSets = new ArrayList<RecordSet>();

    public TransferControlRequestPdu() {
        this.setPduType((short)35);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.orginatingEntityID.getMarshalledSize();
        marshalSize += this.recevingEntityID.getMarshalledSize();
        marshalSize += 4;
        ++marshalSize;
        ++marshalSize;
        marshalSize += this.transferEntityID.getMarshalledSize();
        ++marshalSize;
        for (int idx = 0; idx < this.recordSets.size(); ++idx) {
            RecordSet listElement = this.recordSets.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setOrginatingEntityID(EntityID pOrginatingEntityID) {
        this.orginatingEntityID = pOrginatingEntityID;
    }

    public EntityID getOrginatingEntityID() {
        return this.orginatingEntityID;
    }

    public void setRecevingEntityID(EntityID pRecevingEntityID) {
        this.recevingEntityID = pRecevingEntityID;
    }

    public EntityID getRecevingEntityID() {
        return this.recevingEntityID;
    }

    public void setRequestID(long pRequestID) {
        this.requestID = pRequestID;
    }

    public long getRequestID() {
        return this.requestID;
    }

    public void setRequiredReliabilityService(short pRequiredReliabilityService) {
        this.requiredReliabilityService = pRequiredReliabilityService;
    }

    public short getRequiredReliabilityService() {
        return this.requiredReliabilityService;
    }

    public void setTranferType(short pTranferType) {
        this.tranferType = pTranferType;
    }

    public short getTranferType() {
        return this.tranferType;
    }

    public void setTransferEntityID(EntityID pTransferEntityID) {
        this.transferEntityID = pTransferEntityID;
    }

    public EntityID getTransferEntityID() {
        return this.transferEntityID;
    }

    public short getNumberOfRecordSets() {
        return (short)this.recordSets.size();
    }

    public void setNumberOfRecordSets(short pNumberOfRecordSets) {
        this.numberOfRecordSets = pNumberOfRecordSets;
    }

    public void setRecordSets(List<RecordSet> pRecordSets) {
        this.recordSets = pRecordSets;
    }

    public List<RecordSet> getRecordSets() {
        return this.recordSets;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.orginatingEntityID.marshal(buff);
        this.recevingEntityID.marshal(buff);
        buff.putInt((int)this.requestID);
        buff.put((byte)this.requiredReliabilityService);
        buff.put((byte)this.tranferType);
        this.transferEntityID.marshal(buff);
        buff.put((byte)this.recordSets.size());
        for (int idx = 0; idx < this.recordSets.size(); ++idx) {
            RecordSet aRecordSet = this.recordSets.get(idx);
            aRecordSet.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.orginatingEntityID.unmarshal(buff);
        this.recevingEntityID.unmarshal(buff);
        this.requestID = buff.getInt();
        this.requiredReliabilityService = (short)(buff.get() & 0xFF);
        this.tranferType = (short)(buff.get() & 0xFF);
        this.transferEntityID.unmarshal(buff);
        this.numberOfRecordSets = (short)(buff.get() & 0xFF);
        for (int idx = 0; idx < this.numberOfRecordSets; ++idx) {
            RecordSet anX = new RecordSet();
            anX.unmarshal(buff);
            this.recordSets.add(anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof TransferControlRequestPdu)) {
            return false;
        }
        TransferControlRequestPdu rhs = (TransferControlRequestPdu)obj;
        if (!this.orginatingEntityID.equals(rhs.orginatingEntityID)) {
            ivarsEqual = false;
        }
        if (!this.recevingEntityID.equals(rhs.recevingEntityID)) {
            ivarsEqual = false;
        }
        if (this.requestID != rhs.requestID) {
            ivarsEqual = false;
        }
        if (this.requiredReliabilityService != rhs.requiredReliabilityService) {
            ivarsEqual = false;
        }
        if (this.tranferType != rhs.tranferType) {
            ivarsEqual = false;
        }
        if (!this.transferEntityID.equals(rhs.transferEntityID)) {
            ivarsEqual = false;
        }
        if (this.numberOfRecordSets != rhs.numberOfRecordSets) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.recordSets.size(); ++idx) {
            if (this.recordSets.get(idx).equals(rhs.recordSets.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

