/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.BeamAntennaPattern;
import edu.nps.moves.dis.CcttSincgarsModulationParameters;
import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.JtidsMidsModulationParameters;
import edu.nps.moves.dis.ModulationType;
import edu.nps.moves.dis.RadioCommunicationsFamilyPdu;
import edu.nps.moves.dis.RadioEntityType;
import edu.nps.moves.dis.SphericalHarmonicAntennaPattern;
import edu.nps.moves.dis.Vector3Double;
import edu.nps.moves.dis.Vector3Float;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class TransmitterPdu
extends RadioCommunicationsFamilyPdu
implements Serializable {
    protected EntityID entityId = new EntityID();
    protected int radioId;
    protected RadioEntityType radioEntityType = new RadioEntityType();
    protected short transmitState;
    protected short inputSource;
    protected int padding1;
    protected Vector3Double antennaLocation = new Vector3Double();
    protected Vector3Float relativeAntennaLocation = new Vector3Float();
    protected int antennaPatternType;
    protected int antennaPatternCount;
    protected long frequency;
    protected float transmitFrequencyBandwidth;
    protected float power;
    protected ModulationType modulationType = new ModulationType();
    protected int cryptoSystem;
    protected int cryptoKeyId;
    protected short modulationParameterCount;
    protected int padding2 = 0;
    protected short padding3 = 0;
    protected List<Short> modulationParametersList = new ArrayList<Short>();
    protected List<BeamAntennaPattern> antennaPatternList = new ArrayList<BeamAntennaPattern>();
    protected List<SphericalHarmonicAntennaPattern> sphericalHarmonicAntennaPatternList = new ArrayList<SphericalHarmonicAntennaPattern>();
    protected List<CcttSincgarsModulationParameters> cctSincarsModulationParametersList = new ArrayList<CcttSincgarsModulationParameters>();
    protected List<JtidsMidsModulationParameters> jtidsMidsModulationParametersList = new ArrayList<JtidsMidsModulationParameters>();

    public TransmitterPdu() {
        this.setPduType((short)25);
    }

    @Override
    public int getMarshalledSize() {
        Object listElement;
        int idx;
        int marshalSize = 0;
        this.antennaPatternCount = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.entityId.getMarshalledSize();
        marshalSize += 2;
        marshalSize += this.radioEntityType.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        marshalSize += 2;
        marshalSize += this.antennaLocation.getMarshalledSize();
        marshalSize += this.relativeAntennaLocation.getMarshalledSize();
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 8;
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += this.modulationType.getMarshalledSize();
        marshalSize += 2;
        marshalSize += 2;
        ++marshalSize;
        marshalSize += 2;
        ++marshalSize;
        int nrOfModulationBytes = 0;
        switch (this.getModulationType().getSystem()) {
            case 6: {
                for (idx = 0; idx < this.cctSincarsModulationParametersList.size(); ++idx) {
                    listElement = this.cctSincarsModulationParametersList.get(idx);
                    marshalSize += ((CcttSincgarsModulationParameters)listElement).getMarshalledSize();
                    nrOfModulationBytes += ((CcttSincgarsModulationParameters)listElement).getMarshalledSize();
                }
                break;
            }
            case 8: {
                for (idx = 0; idx < this.jtidsMidsModulationParametersList.size(); ++idx) {
                    listElement = this.jtidsMidsModulationParametersList.get(idx);
                    marshalSize += ((JtidsMidsModulationParameters)listElement).getMarshalledSize();
                    nrOfModulationBytes += ((JtidsMidsModulationParameters)listElement).getMarshalledSize();
                }
                break;
            }
            default: {
                marshalSize += this.modulationParametersList.size() * 2;
                nrOfModulationBytes += this.modulationParametersList.size() * 2;
            }
        }
        if (nrOfModulationBytes % 8 > 0) {
            int remainder = nrOfModulationBytes % 8;
            switch (remainder) {
                case 1: {
                    marshalSize += 7;
                    break;
                }
                case 2: {
                    marshalSize += 6;
                    break;
                }
                case 3: {
                    marshalSize += 5;
                    break;
                }
                case 4: {
                    marshalSize += 4;
                    break;
                }
                case 5: {
                    marshalSize += 3;
                    break;
                }
                case 6: {
                    marshalSize += 2;
                    break;
                }
                case 7: {
                    ++marshalSize;
                }
            }
        }
        switch (this.antennaPatternType) {
            case 0: {
                break;
            }
            case 1: {
                for (idx = 0; idx < this.antennaPatternList.size(); ++idx) {
                    listElement = this.antennaPatternList.get(idx);
                    marshalSize += ((BeamAntennaPattern)listElement).getMarshalledSize();
                    this.antennaPatternCount += ((BeamAntennaPattern)listElement).getMarshalledSize();
                }
                if ((this.antennaPatternList.size() & 1) == 0) break;
                marshalSize += 4;
                this.antennaPatternCount += 4;
                break;
            }
            case 2: {
                int nrOf16BitBlocks = 0;
                for (int idx2 = 0; idx2 < this.sphericalHarmonicAntennaPatternList.size(); ++idx2) {
                    SphericalHarmonicAntennaPattern listElement2 = this.sphericalHarmonicAntennaPatternList.get(idx2);
                    marshalSize += listElement2.getMarshalledSize();
                    this.antennaPatternCount += listElement2.getMarshalledSize();
                    byte n = listElement2.getHarmonicOrder();
                    ++nrOf16BitBlocks;
                    nrOf16BitBlocks += 2 * listElement2.getCoefficientsList().size();
                }
                if (nrOf16BitBlocks % 4 == 3) {
                    marshalSize += 2;
                    this.antennaPatternCount += 2;
                    break;
                }
                if (nrOf16BitBlocks % 4 == 1) {
                    marshalSize += 6;
                    this.antennaPatternCount += 6;
                    break;
                }
                if (nrOf16BitBlocks % 4 != 2) break;
                marshalSize += 4;
                this.antennaPatternCount += 4;
            }
        }
        return marshalSize;
    }

    public void setEntityId(EntityID pEntityId) {
        this.entityId = pEntityId;
    }

    public EntityID getEntityId() {
        return this.entityId;
    }

    public void setRadioId(int pRadioId) {
        this.radioId = pRadioId;
    }

    public int getRadioId() {
        return this.radioId;
    }

    public void setRadioEntityType(RadioEntityType pRadioEntityType) {
        this.radioEntityType = pRadioEntityType;
    }

    public RadioEntityType getRadioEntityType() {
        return this.radioEntityType;
    }

    public void setTransmitState(short pTransmitState) {
        this.transmitState = pTransmitState;
    }

    public short getTransmitState() {
        return this.transmitState;
    }

    public void setInputSource(short pInputSource) {
        this.inputSource = pInputSource;
    }

    public short getInputSource() {
        return this.inputSource;
    }

    public void setPadding1(int pPadding1) {
        this.padding1 = pPadding1;
    }

    public int getPadding1() {
        return this.padding1;
    }

    public void setAntennaLocation(Vector3Double pAntennaLocation) {
        this.antennaLocation = pAntennaLocation;
    }

    public Vector3Double getAntennaLocation() {
        return this.antennaLocation;
    }

    public void setRelativeAntennaLocation(Vector3Float pRelativeAntennaLocation) {
        this.relativeAntennaLocation = pRelativeAntennaLocation;
    }

    public Vector3Float getRelativeAntennaLocation() {
        return this.relativeAntennaLocation;
    }

    public void setAntennaPatternType(int pAntennaPatternType) {
        this.antennaPatternType = pAntennaPatternType;
    }

    public int getAntennaPatternType() {
        return this.antennaPatternType;
    }

    public int getAntennaPatternCount() {
        return this.antennaPatternList.size();
    }

    public void setAntennaPatternCount(int pAntennaPatternCount) {
        this.antennaPatternCount = pAntennaPatternCount;
    }

    public void setFrequency(long pFrequency) {
        this.frequency = pFrequency;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public void setTransmitFrequencyBandwidth(float pTransmitFrequencyBandwidth) {
        this.transmitFrequencyBandwidth = pTransmitFrequencyBandwidth;
    }

    public float getTransmitFrequencyBandwidth() {
        return this.transmitFrequencyBandwidth;
    }

    public void setPower(float pPower) {
        this.power = pPower;
    }

    public float getPower() {
        return this.power;
    }

    public void setModulationType(ModulationType pModulationType) {
        this.modulationType = pModulationType;
    }

    public ModulationType getModulationType() {
        return this.modulationType;
    }

    public void setCryptoSystem(int pCryptoSystem) {
        this.cryptoSystem = pCryptoSystem;
    }

    public int getCryptoSystem() {
        return this.cryptoSystem;
    }

    public void setCryptoKeyId(int pCryptoKeyId) {
        this.cryptoKeyId = pCryptoKeyId;
    }

    public int getCryptoKeyId() {
        return this.cryptoKeyId;
    }

    public short getModulationParameterCount() {
        return this.modulationParameterCount;
    }

    public void setModulationParameterCount(short pModulationParameterCount) {
        this.modulationParameterCount = pModulationParameterCount;
    }

    public void setPadding2(int pPadding2) {
        this.padding2 = pPadding2;
    }

    public int getPadding2() {
        return this.padding2;
    }

    public void setPadding3(short pPadding3) {
        this.padding3 = pPadding3;
    }

    public short getPadding3() {
        return this.padding3;
    }

    public void setModulationParametersList(List<Short> pModulationParametersList) {
        this.modulationParametersList = pModulationParametersList;
    }

    public List<Short> getModulationParametersList() {
        return this.modulationParametersList;
    }

    public void setAntennaPatternList(List<BeamAntennaPattern> pAntennaPatternList) {
        this.antennaPatternList = pAntennaPatternList;
    }

    public List<BeamAntennaPattern> getAntennaPatternList() {
        return this.antennaPatternList;
    }

    public void setSphericalHarmonicAntennaPatternList(List<SphericalHarmonicAntennaPattern> aSphericalHarmonicAntennaPatternList) {
        this.sphericalHarmonicAntennaPatternList = aSphericalHarmonicAntennaPatternList;
    }

    public List<SphericalHarmonicAntennaPattern> getSphericalHarmonicAntennaPatternList() {
        return this.sphericalHarmonicAntennaPatternList;
    }

    public List<CcttSincgarsModulationParameters> getCctSincarsModulationParametersList() {
        return this.cctSincarsModulationParametersList;
    }

    public void setCctSincarsModulationParametersList(List<CcttSincgarsModulationParameters> list) {
        this.cctSincarsModulationParametersList = list;
    }

    public List<JtidsMidsModulationParameters> getJtidsMidsModulationParametersList() {
        return this.jtidsMidsModulationParametersList;
    }

    public void setJtidsMidsModulationParameters(List<JtidsMidsModulationParameters> list) {
        this.jtidsMidsModulationParametersList = list;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        int idx;
        super.marshal(buff);
        this.entityId.marshal(buff);
        buff.putShort((short)this.radioId);
        this.radioEntityType.marshal(buff);
        buff.put((byte)this.transmitState);
        buff.put((byte)this.inputSource);
        buff.putShort((short)this.padding1);
        this.antennaLocation.marshal(buff);
        this.relativeAntennaLocation.marshal(buff);
        buff.putShort((short)this.antennaPatternType);
        buff.putShort((short)this.antennaPatternCount);
        buff.putLong(this.frequency);
        buff.putFloat(this.transmitFrequencyBandwidth);
        buff.putFloat(this.power);
        this.modulationType.marshal(buff);
        buff.putShort((short)this.cryptoSystem);
        buff.putShort((short)this.cryptoKeyId);
        buff.put((byte)this.modulationParameterCount);
        buff.putShort((short)this.padding2);
        buff.put((byte)this.padding3);
        int nrOfModulationBytes = 0;
        switch (this.getModulationType().getSystem()) {
            case 6: {
                Object parameterRecord;
                for (idx = 0; idx < this.cctSincarsModulationParametersList.size(); ++idx) {
                    parameterRecord = this.cctSincarsModulationParametersList.get(idx);
                    ((CcttSincgarsModulationParameters)parameterRecord).marshal(buff);
                    nrOfModulationBytes += ((CcttSincgarsModulationParameters)parameterRecord).getMarshalledSize();
                }
                break;
            }
            case 8: {
                Object parameterRecord;
                for (idx = 0; idx < this.jtidsMidsModulationParametersList.size(); ++idx) {
                    parameterRecord = this.jtidsMidsModulationParametersList.get(idx);
                    ((JtidsMidsModulationParameters)parameterRecord).marshal(buff);
                    nrOfModulationBytes += ((JtidsMidsModulationParameters)parameterRecord).getMarshalledSize();
                }
                break;
            }
            default: {
                for (idx = 0; idx < this.modulationParametersList.size(); ++idx) {
                    Short modulationParameter = this.modulationParametersList.get(idx);
                    buff.putShort(modulationParameter);
                    nrOfModulationBytes += 2;
                }
            }
        }
        if (nrOfModulationBytes % 8 > 0) {
            int remainder = nrOfModulationBytes % 8;
            switch (remainder) {
                case 1: {
                    buff.put((byte)0);
                    buff.putShort((short)0);
                    buff.putInt(0);
                    break;
                }
                case 2: {
                    buff.putShort((short)0);
                    buff.putInt(0);
                    break;
                }
                case 3: {
                    buff.put((byte)0);
                    buff.putInt(0);
                    break;
                }
                case 4: {
                    buff.putInt(0);
                    break;
                }
                case 5: {
                    buff.put((byte)0);
                    buff.putShort((short)0);
                    break;
                }
                case 6: {
                    buff.putShort((short)0);
                    break;
                }
                case 7: {
                    buff.put((byte)0);
                }
            }
        }
        switch (this.antennaPatternType) {
            case 0: {
                break;
            }
            case 1: {
                for (idx = 0; idx < this.antennaPatternList.size(); ++idx) {
                    BeamAntennaPattern aBeamAntennaPattern = this.antennaPatternList.get(idx);
                    aBeamAntennaPattern.marshal(buff);
                }
                if ((this.antennaPatternList.size() & 1) == 0) break;
                buff.putInt(-1);
                break;
            }
            case 2: {
                int nrOf16BitBlocks = 0;
                for (int idx2 = 0; idx2 < this.sphericalHarmonicAntennaPatternList.size(); ++idx2) {
                    SphericalHarmonicAntennaPattern aSphericalHarmonicAntennaPattern = this.sphericalHarmonicAntennaPatternList.get(idx2);
                    aSphericalHarmonicAntennaPattern.marshal(buff);
                    byte n = aSphericalHarmonicAntennaPattern.getHarmonicOrder();
                    ++nrOf16BitBlocks;
                    nrOf16BitBlocks += 2 * aSphericalHarmonicAntennaPattern.getCoefficientsList().size();
                }
                if (nrOf16BitBlocks % 4 == 3) {
                    buff.putShort((short)-1);
                    break;
                }
                if (nrOf16BitBlocks % 4 == 1) {
                    buff.putShort((short)-1);
                    buff.putInt(-1);
                    break;
                }
                if (nrOf16BitBlocks % 4 != 2) break;
                buff.putInt(-1);
            }
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        int idx;
        super.unmarshal(buff);
        this.entityId.unmarshal(buff);
        this.radioId = buff.getShort() & 0xFFFF;
        this.radioEntityType.unmarshal(buff);
        this.transmitState = (short)(buff.get() & 0xFF);
        this.inputSource = (short)(buff.get() & 0xFF);
        this.padding1 = buff.getShort() & 0xFFFF;
        this.antennaLocation.unmarshal(buff);
        this.relativeAntennaLocation.unmarshal(buff);
        this.antennaPatternType = buff.getShort() & 0xFFFF;
        this.antennaPatternCount = buff.getShort() & 0xFFFF;
        this.frequency = buff.getLong();
        this.transmitFrequencyBandwidth = buff.getFloat();
        this.power = buff.getFloat();
        this.modulationType.unmarshal(buff);
        this.cryptoSystem = buff.getShort() & 0xFFFF;
        this.cryptoKeyId = buff.getShort() & 0xFFFF;
        this.modulationParameterCount = (short)(buff.get() & 0xFF);
        this.padding2 = buff.getShort() & 0xFFFF;
        this.padding3 = (short)(buff.get() & 0xFF);
        int remainder = 0;
        int modRecordSize = 0;
        switch (this.getModulationType().getSystem()) {
            case 6: {
                for (idx = 0; idx < this.modulationParameterCount / 15; ++idx) {
                    CcttSincgarsModulationParameters parameterRecord = new CcttSincgarsModulationParameters();
                    parameterRecord.unmarshal(buff);
                    this.cctSincarsModulationParametersList.add(parameterRecord);
                }
                modRecordSize = 15;
                break;
            }
            case 8: {
                for (idx = 0; idx < this.modulationParameterCount / 8; ++idx) {
                    JtidsMidsModulationParameters parameterRecord = new JtidsMidsModulationParameters();
                    parameterRecord.unmarshal(buff);
                    this.jtidsMidsModulationParametersList.add(parameterRecord);
                }
                modRecordSize = 8;
                break;
            }
            default: {
                int modulationParameters = this.modulationParameterCount / 2;
                for (int idx2 = 0; idx2 < modulationParameters; ++idx2) {
                    Short modulationParameter = buff.getShort();
                    this.modulationParametersList.add(modulationParameter);
                }
                modRecordSize = 8;
            }
        }
        remainder = this.modulationParameterCount % modRecordSize;
        if (remainder > 0) {
            for (int i = 0; i < remainder; ++i) {
                buff.get();
            }
        }
        switch (this.antennaPatternType) {
            case 0: {
                break;
            }
            case 1: {
                for (idx = 0; idx < this.antennaPatternCount / 36; ++idx) {
                    BeamAntennaPattern anX = new BeamAntennaPattern();
                    anX.unmarshal(buff);
                    this.antennaPatternList.add(anX);
                }
                break;
            }
            case 2: {
                byte[] tmpByteArray = new byte[this.antennaPatternCount];
                for (int i = 0; i < this.antennaPatternCount; ++i) {
                    tmpByteArray[i] = buff.get();
                }
                ByteArrayInputStream is = new ByteArrayInputStream(tmpByteArray);
                ByteBuffer buffCopy = ByteBuffer.wrap(tmpByteArray);
                DataInputStream disCopy = new DataInputStream(is);
                int recordCount = 0;
                int fieldSizeLeftOver = this.antennaPatternCount;
                boolean runLoop = true;
                int counter = 0;
                while (runLoop) {
                    if (fieldSizeLeftOver > 0) {
                        byte harmonicOrder = tmpByteArray[counter];
                        int recordSize = (harmonicOrder * harmonicOrder + 2 * harmonicOrder + 1) * 4 + 2;
                        if (fieldSizeLeftOver / recordSize >= 1 && harmonicOrder >= 0) {
                            counter += recordSize;
                            fieldSizeLeftOver -= recordSize;
                            ++recordCount;
                            continue;
                        }
                        runLoop = false;
                        continue;
                    }
                    runLoop = false;
                }
                for (int idx3 = 0; idx3 < recordCount; ++idx3) {
                    SphericalHarmonicAntennaPattern anX = new SphericalHarmonicAntennaPattern();
                    anX.unmarshal(buffCopy);
                    this.sphericalHarmonicAntennaPatternList.add(anX);
                }
                break;
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        int idx;
        boolean ivarsEqual = true;
        if (!(obj instanceof TransmitterPdu)) {
            return false;
        }
        TransmitterPdu rhs = (TransmitterPdu)obj;
        if (!this.entityId.equals(rhs.entityId)) {
            ivarsEqual = false;
        }
        if (this.radioId != rhs.radioId) {
            ivarsEqual = false;
        }
        if (!this.radioEntityType.equals(rhs.radioEntityType)) {
            ivarsEqual = false;
        }
        if (this.transmitState != rhs.transmitState) {
            ivarsEqual = false;
        }
        if (this.inputSource != rhs.inputSource) {
            ivarsEqual = false;
        }
        if (this.padding1 != rhs.padding1) {
            ivarsEqual = false;
        }
        if (!this.antennaLocation.equals(rhs.antennaLocation)) {
            ivarsEqual = false;
        }
        if (!this.relativeAntennaLocation.equals(rhs.relativeAntennaLocation)) {
            ivarsEqual = false;
        }
        if (this.antennaPatternType != rhs.antennaPatternType) {
            ivarsEqual = false;
        }
        if (this.antennaPatternCount != rhs.antennaPatternCount) {
            ivarsEqual = false;
        }
        if (this.frequency != rhs.frequency) {
            ivarsEqual = false;
        }
        if (this.transmitFrequencyBandwidth != rhs.transmitFrequencyBandwidth) {
            ivarsEqual = false;
        }
        if (this.power != rhs.power) {
            ivarsEqual = false;
        }
        if (!this.modulationType.equals(rhs.modulationType)) {
            ivarsEqual = false;
        }
        if (this.cryptoSystem != rhs.cryptoSystem) {
            ivarsEqual = false;
        }
        if (this.cryptoKeyId != rhs.cryptoKeyId) {
            ivarsEqual = false;
        }
        if (this.modulationParameterCount != rhs.modulationParameterCount) {
            ivarsEqual = false;
        }
        if (this.padding2 != rhs.padding2) {
            ivarsEqual = false;
        }
        if (this.padding3 != rhs.padding3) {
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.modulationParametersList.size(); ++idx) {
            if (this.modulationParametersList.get(idx).equals(rhs.modulationParametersList.get(idx))) continue;
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.antennaPatternList.size(); ++idx) {
            if (this.antennaPatternList.get(idx).equals(rhs.antennaPatternList.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

