/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis;

import edu.nps.moves.dis.AcousticEmitterSystemData;
import edu.nps.moves.dis.ApaData;
import edu.nps.moves.dis.DistributedEmissionsFamilyPdu;
import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.EventID;
import edu.nps.moves.dis.ShaftRPMs;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class UaPdu
extends DistributedEmissionsFamilyPdu
implements Serializable {
    protected EntityID emittingEntityID = new EntityID();
    protected EventID eventID = new EventID();
    protected byte stateChangeIndicator;
    protected byte pad;
    protected int passiveParameterIndex;
    protected short propulsionPlantConfiguration;
    protected short numberOfShafts;
    protected short numberOfAPAs;
    protected short numberOfUAEmitterSystems;
    protected List<ShaftRPMs> shaftRPMs = new ArrayList<ShaftRPMs>();
    protected List<ApaData> apaData = new ArrayList<ApaData>();
    protected List<AcousticEmitterSystemData> emitterSystems = new ArrayList<AcousticEmitterSystemData>();

    public UaPdu() {
        this.setPduType((short)29);
    }

    @Override
    public int getMarshalledSize() {
        Serializable listElement;
        int idx;
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.emittingEntityID.getMarshalledSize();
        marshalSize += this.eventID.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        marshalSize += 2;
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        for (idx = 0; idx < this.shaftRPMs.size(); ++idx) {
            listElement = this.shaftRPMs.get(idx);
            marshalSize += ((ShaftRPMs)listElement).getMarshalledSize();
        }
        for (idx = 0; idx < this.apaData.size(); ++idx) {
            listElement = this.apaData.get(idx);
            marshalSize += ((ApaData)listElement).getMarshalledSize();
        }
        for (idx = 0; idx < this.emitterSystems.size(); ++idx) {
            listElement = this.emitterSystems.get(idx);
            marshalSize += ((AcousticEmitterSystemData)listElement).getMarshalledSize();
        }
        return marshalSize;
    }

    public void setEmittingEntityID(EntityID pEmittingEntityID) {
        this.emittingEntityID = pEmittingEntityID;
    }

    public EntityID getEmittingEntityID() {
        return this.emittingEntityID;
    }

    public void setEventID(EventID pEventID) {
        this.eventID = pEventID;
    }

    public EventID getEventID() {
        return this.eventID;
    }

    public void setStateChangeIndicator(byte pStateChangeIndicator) {
        this.stateChangeIndicator = pStateChangeIndicator;
    }

    public byte getStateChangeIndicator() {
        return this.stateChangeIndicator;
    }

    public void setPad(byte pPad) {
        this.pad = pPad;
    }

    public byte getPad() {
        return this.pad;
    }

    public void setPassiveParameterIndex(int pPassiveParameterIndex) {
        this.passiveParameterIndex = pPassiveParameterIndex;
    }

    public int getPassiveParameterIndex() {
        return this.passiveParameterIndex;
    }

    public void setPropulsionPlantConfiguration(short pPropulsionPlantConfiguration) {
        this.propulsionPlantConfiguration = pPropulsionPlantConfiguration;
    }

    public short getPropulsionPlantConfiguration() {
        return this.propulsionPlantConfiguration;
    }

    public short getNumberOfShafts() {
        return (short)this.shaftRPMs.size();
    }

    public void setNumberOfShafts(short pNumberOfShafts) {
        this.numberOfShafts = pNumberOfShafts;
    }

    public short getNumberOfAPAs() {
        return (short)this.apaData.size();
    }

    public void setNumberOfAPAs(short pNumberOfAPAs) {
        this.numberOfAPAs = pNumberOfAPAs;
    }

    public short getNumberOfUAEmitterSystems() {
        return (short)this.emitterSystems.size();
    }

    public void setNumberOfUAEmitterSystems(short pNumberOfUAEmitterSystems) {
        this.numberOfUAEmitterSystems = pNumberOfUAEmitterSystems;
    }

    public void setShaftRPMs(List<ShaftRPMs> pShaftRPMs) {
        this.shaftRPMs = pShaftRPMs;
    }

    public List<ShaftRPMs> getShaftRPMs() {
        return this.shaftRPMs;
    }

    public void setApaData(List<ApaData> pApaData) {
        this.apaData = pApaData;
    }

    public List<ApaData> getApaData() {
        return this.apaData;
    }

    public void setEmitterSystems(List<AcousticEmitterSystemData> pEmitterSystems) {
        this.emitterSystems = pEmitterSystems;
    }

    public List<AcousticEmitterSystemData> getEmitterSystems() {
        return this.emitterSystems;
    }

    @Override
    public void marshal(ByteBuffer buff) {
        int idx;
        super.marshal(buff);
        this.emittingEntityID.marshal(buff);
        this.eventID.marshal(buff);
        buff.put(this.stateChangeIndicator);
        buff.put(this.pad);
        buff.putShort((short)this.passiveParameterIndex);
        buff.put((byte)this.propulsionPlantConfiguration);
        buff.put((byte)this.shaftRPMs.size());
        buff.put((byte)this.apaData.size());
        buff.put((byte)this.emitterSystems.size());
        for (idx = 0; idx < this.shaftRPMs.size(); ++idx) {
            ShaftRPMs aShaftRPMs = this.shaftRPMs.get(idx);
            aShaftRPMs.marshal(buff);
        }
        for (idx = 0; idx < this.apaData.size(); ++idx) {
            ApaData aApaData = this.apaData.get(idx);
            aApaData.marshal(buff);
        }
        for (idx = 0; idx < this.emitterSystems.size(); ++idx) {
            AcousticEmitterSystemData aAcousticEmitterSystemData = this.emitterSystems.get(idx);
            aAcousticEmitterSystemData.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        Serializable anX;
        int idx;
        super.unmarshal(buff);
        this.emittingEntityID.unmarshal(buff);
        this.eventID.unmarshal(buff);
        this.stateChangeIndicator = buff.get();
        this.pad = buff.get();
        this.passiveParameterIndex = buff.getShort() & 0xFFFF;
        this.propulsionPlantConfiguration = (short)(buff.get() & 0xFF);
        this.numberOfShafts = (short)(buff.get() & 0xFF);
        this.numberOfAPAs = (short)(buff.get() & 0xFF);
        this.numberOfUAEmitterSystems = (short)(buff.get() & 0xFF);
        for (idx = 0; idx < this.numberOfShafts; ++idx) {
            anX = new ShaftRPMs();
            ((ShaftRPMs)anX).unmarshal(buff);
            this.shaftRPMs.add((ShaftRPMs)anX);
        }
        for (idx = 0; idx < this.numberOfAPAs; ++idx) {
            anX = new ApaData();
            ((ApaData)anX).unmarshal(buff);
            this.apaData.add((ApaData)anX);
        }
        for (idx = 0; idx < this.numberOfUAEmitterSystems; ++idx) {
            anX = new AcousticEmitterSystemData();
            ((AcousticEmitterSystemData)anX).unmarshal(buff);
            this.emitterSystems.add((AcousticEmitterSystemData)anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        int idx;
        boolean ivarsEqual = true;
        if (!(obj instanceof UaPdu)) {
            return false;
        }
        UaPdu rhs = (UaPdu)obj;
        if (!this.emittingEntityID.equals(rhs.emittingEntityID)) {
            ivarsEqual = false;
        }
        if (!this.eventID.equals(rhs.eventID)) {
            ivarsEqual = false;
        }
        if (this.stateChangeIndicator != rhs.stateChangeIndicator) {
            ivarsEqual = false;
        }
        if (this.pad != rhs.pad) {
            ivarsEqual = false;
        }
        if (this.passiveParameterIndex != rhs.passiveParameterIndex) {
            ivarsEqual = false;
        }
        if (this.propulsionPlantConfiguration != rhs.propulsionPlantConfiguration) {
            ivarsEqual = false;
        }
        if (this.numberOfShafts != rhs.numberOfShafts) {
            ivarsEqual = false;
        }
        if (this.numberOfAPAs != rhs.numberOfAPAs) {
            ivarsEqual = false;
        }
        if (this.numberOfUAEmitterSystems != rhs.numberOfUAEmitterSystems) {
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.shaftRPMs.size(); ++idx) {
            if (this.shaftRPMs.get(idx).equals(rhs.shaftRPMs.get(idx))) continue;
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.apaData.size(); ++idx) {
            if (this.apaData.get(idx).equals(rhs.apaData.get(idx))) continue;
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.emitterSystems.size(); ++idx) {
            if (this.emitterSystems.get(idx).equals(rhs.emitterSystems.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

