/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class BlankingSector
implements Serializable {
    protected int recordType = 3500;
    protected int recordLength = 40;
    protected int padding = 0;
    protected short emitterNumber;
    protected short beamNumber;
    protected short stateIndicator;
    protected short padding2 = 0;
    protected float leftAzimuth;
    protected float rightAzimuth;
    protected float lowerElevation;
    protected float upperElevation;
    protected float residualPower;
    protected int padding3 = 0;
    protected int padding4 = 0;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 4;
        marshalSize += 2;
        marshalSize += 2;
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        return marshalSize += 4;
    }

    public void setRecordType(int pRecordType) {
        this.recordType = pRecordType;
    }

    public int getRecordType() {
        return this.recordType;
    }

    public void setRecordLength(int pRecordLength) {
        this.recordLength = pRecordLength;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public void setPadding(int pPadding) {
        this.padding = pPadding;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setEmitterNumber(short pEmitterNumber) {
        this.emitterNumber = pEmitterNumber;
    }

    public short getEmitterNumber() {
        return this.emitterNumber;
    }

    public void setBeamNumber(short pBeamNumber) {
        this.beamNumber = pBeamNumber;
    }

    public short getBeamNumber() {
        return this.beamNumber;
    }

    public void setStateIndicator(short pStateIndicator) {
        this.stateIndicator = pStateIndicator;
    }

    public short getStateIndicator() {
        return this.stateIndicator;
    }

    public void setPadding2(short pPadding2) {
        this.padding2 = pPadding2;
    }

    public short getPadding2() {
        return this.padding2;
    }

    public void setLeftAzimuth(float pLeftAzimuth) {
        this.leftAzimuth = pLeftAzimuth;
    }

    public float getLeftAzimuth() {
        return this.leftAzimuth;
    }

    public void setRightAzimuth(float pRightAzimuth) {
        this.rightAzimuth = pRightAzimuth;
    }

    public float getRightAzimuth() {
        return this.rightAzimuth;
    }

    public void setLowerElevation(float pLowerElevation) {
        this.lowerElevation = pLowerElevation;
    }

    public float getLowerElevation() {
        return this.lowerElevation;
    }

    public void setUpperElevation(float pUpperElevation) {
        this.upperElevation = pUpperElevation;
    }

    public float getUpperElevation() {
        return this.upperElevation;
    }

    public void setResidualPower(float pResidualPower) {
        this.residualPower = pResidualPower;
    }

    public float getResidualPower() {
        return this.residualPower;
    }

    public void setPadding3(int pPadding3) {
        this.padding3 = pPadding3;
    }

    public int getPadding3() {
        return this.padding3;
    }

    public void setPadding4(int pPadding4) {
        this.padding4 = pPadding4;
    }

    public int getPadding4() {
        return this.padding4;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeInt(this.recordType);
            dos.writeShort((short)this.recordLength);
            dos.writeShort((short)this.padding);
            dos.writeByte((byte)this.emitterNumber);
            dos.writeByte((byte)this.beamNumber);
            dos.writeByte((byte)this.stateIndicator);
            dos.writeByte((byte)this.padding2);
            dos.writeFloat(this.leftAzimuth);
            dos.writeFloat(this.rightAzimuth);
            dos.writeFloat(this.lowerElevation);
            dos.writeFloat(this.upperElevation);
            dos.writeFloat(this.residualPower);
            dos.writeInt(this.padding3);
            dos.writeInt(this.padding4);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.recordType = dis.readInt();
            this.recordLength = dis.readUnsignedShort();
            this.padding = dis.readUnsignedShort();
            this.emitterNumber = (short)dis.readUnsignedByte();
            this.beamNumber = (short)dis.readUnsignedByte();
            this.stateIndicator = (short)dis.readUnsignedByte();
            this.padding2 = (short)dis.readUnsignedByte();
            this.leftAzimuth = dis.readFloat();
            this.rightAzimuth = dis.readFloat();
            this.lowerElevation = dis.readFloat();
            this.upperElevation = dis.readFloat();
            this.residualPower = dis.readFloat();
            this.padding3 = dis.readInt();
            this.padding4 = dis.readInt();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.putInt(this.recordType);
        buff.putShort((short)this.recordLength);
        buff.putShort((short)this.padding);
        buff.put((byte)this.emitterNumber);
        buff.put((byte)this.beamNumber);
        buff.put((byte)this.stateIndicator);
        buff.put((byte)this.padding2);
        buff.putFloat(this.leftAzimuth);
        buff.putFloat(this.rightAzimuth);
        buff.putFloat(this.lowerElevation);
        buff.putFloat(this.upperElevation);
        buff.putFloat(this.residualPower);
        buff.putInt(this.padding3);
        buff.putInt(this.padding4);
    }

    public void unmarshal(ByteBuffer buff) {
        this.recordType = buff.getInt();
        this.recordLength = buff.getShort() & 0xFFFF;
        this.padding = buff.getShort() & 0xFFFF;
        this.emitterNumber = (short)(buff.get() & 0xFF);
        this.beamNumber = (short)(buff.get() & 0xFF);
        this.stateIndicator = (short)(buff.get() & 0xFF);
        this.padding2 = (short)(buff.get() & 0xFF);
        this.leftAzimuth = buff.getFloat();
        this.rightAzimuth = buff.getFloat();
        this.lowerElevation = buff.getFloat();
        this.upperElevation = buff.getFloat();
        this.residualPower = buff.getFloat();
        this.padding3 = buff.getInt();
        this.padding4 = buff.getInt();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof BlankingSector)) {
            return false;
        }
        BlankingSector rhs = (BlankingSector)obj;
        if (this.recordType != rhs.recordType) {
            ivarsEqual = false;
        }
        if (this.recordLength != rhs.recordLength) {
            ivarsEqual = false;
        }
        if (this.padding != rhs.padding) {
            ivarsEqual = false;
        }
        if (this.emitterNumber != rhs.emitterNumber) {
            ivarsEqual = false;
        }
        if (this.beamNumber != rhs.beamNumber) {
            ivarsEqual = false;
        }
        if (this.stateIndicator != rhs.stateIndicator) {
            ivarsEqual = false;
        }
        if (this.padding2 != rhs.padding2) {
            ivarsEqual = false;
        }
        if (this.leftAzimuth != rhs.leftAzimuth) {
            ivarsEqual = false;
        }
        if (this.rightAzimuth != rhs.rightAzimuth) {
            ivarsEqual = false;
        }
        if (this.lowerElevation != rhs.lowerElevation) {
            ivarsEqual = false;
        }
        if (this.upperElevation != rhs.upperElevation) {
            ivarsEqual = false;
        }
        if (this.residualPower != rhs.residualPower) {
            ivarsEqual = false;
        }
        if (this.padding3 != rhs.padding3) {
            ivarsEqual = false;
        }
        if (this.padding4 != rhs.padding4) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

