/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.ClockTime;
import edu.nps.moves.dis7.EntityType;
import edu.nps.moves.dis7.StandardVariableSpecification;
import edu.nps.moves.dis7.Vector3Float;
import edu.nps.moves.dis7.WarfareFamilyPdu;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class DirectedEnergyFirePdu
extends WarfareFamilyPdu
implements Serializable {
    protected EntityType munitionType = new EntityType();
    protected ClockTime shotStartTime = new ClockTime();
    protected float commulativeShotTime;
    protected Vector3Float ApertureEmitterLocation = new Vector3Float();
    protected float apertureDiameter;
    protected float wavelength;
    protected float peakIrradiance;
    protected float pulseRepetitionFrequency;
    protected int pulseWidth;
    protected int flags;
    protected byte pulseShape;
    protected short padding1;
    protected long padding2;
    protected int padding3;
    protected int numberOfDERecords;
    protected List<StandardVariableSpecification> dERecords = new ArrayList<StandardVariableSpecification>();

    public DirectedEnergyFirePdu() {
        this.setPduType((short)68);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.munitionType.getMarshalledSize();
        marshalSize += this.shotStartTime.getMarshalledSize();
        marshalSize += 4;
        marshalSize += this.ApertureEmitterLocation.getMarshalledSize();
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += 4;
        ++marshalSize;
        ++marshalSize;
        marshalSize += 4;
        marshalSize += 2;
        marshalSize += 2;
        for (int idx = 0; idx < this.dERecords.size(); ++idx) {
            StandardVariableSpecification listElement = this.dERecords.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setMunitionType(EntityType pMunitionType) {
        this.munitionType = pMunitionType;
    }

    public EntityType getMunitionType() {
        return this.munitionType;
    }

    public void setShotStartTime(ClockTime pShotStartTime) {
        this.shotStartTime = pShotStartTime;
    }

    public ClockTime getShotStartTime() {
        return this.shotStartTime;
    }

    public void setCommulativeShotTime(float pCommulativeShotTime) {
        this.commulativeShotTime = pCommulativeShotTime;
    }

    public float getCommulativeShotTime() {
        return this.commulativeShotTime;
    }

    public void setApertureEmitterLocation(Vector3Float pApertureEmitterLocation) {
        this.ApertureEmitterLocation = pApertureEmitterLocation;
    }

    public Vector3Float getApertureEmitterLocation() {
        return this.ApertureEmitterLocation;
    }

    public void setApertureDiameter(float pApertureDiameter) {
        this.apertureDiameter = pApertureDiameter;
    }

    public float getApertureDiameter() {
        return this.apertureDiameter;
    }

    public void setWavelength(float pWavelength) {
        this.wavelength = pWavelength;
    }

    public float getWavelength() {
        return this.wavelength;
    }

    public void setPeakIrradiance(float pPeakIrradiance) {
        this.peakIrradiance = pPeakIrradiance;
    }

    public float getPeakIrradiance() {
        return this.peakIrradiance;
    }

    public void setPulseRepetitionFrequency(float pPulseRepetitionFrequency) {
        this.pulseRepetitionFrequency = pPulseRepetitionFrequency;
    }

    public float getPulseRepetitionFrequency() {
        return this.pulseRepetitionFrequency;
    }

    public void setPulseWidth(int pPulseWidth) {
        this.pulseWidth = pPulseWidth;
    }

    public int getPulseWidth() {
        return this.pulseWidth;
    }

    public void setFlags(int pFlags) {
        this.flags = pFlags;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setPulseShape(byte pPulseShape) {
        this.pulseShape = pPulseShape;
    }

    public byte getPulseShape() {
        return this.pulseShape;
    }

    public void setPadding1(short pPadding1) {
        this.padding1 = pPadding1;
    }

    public short getPadding1() {
        return this.padding1;
    }

    public void setPadding2(long pPadding2) {
        this.padding2 = pPadding2;
    }

    public long getPadding2() {
        return this.padding2;
    }

    public void setPadding3(int pPadding3) {
        this.padding3 = pPadding3;
    }

    public int getPadding3() {
        return this.padding3;
    }

    public int getNumberOfDERecords() {
        return this.dERecords.size();
    }

    public void setNumberOfDERecords(int pNumberOfDERecords) {
        this.numberOfDERecords = pNumberOfDERecords;
    }

    public void setDERecords(List<StandardVariableSpecification> pDERecords) {
        this.dERecords = pDERecords;
    }

    public List<StandardVariableSpecification> getDERecords() {
        return this.dERecords;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            this.munitionType.marshal(dos);
            this.shotStartTime.marshal(dos);
            dos.writeFloat(this.commulativeShotTime);
            this.ApertureEmitterLocation.marshal(dos);
            dos.writeFloat(this.apertureDiameter);
            dos.writeFloat(this.wavelength);
            dos.writeFloat(this.peakIrradiance);
            dos.writeFloat(this.pulseRepetitionFrequency);
            dos.writeInt(this.pulseWidth);
            dos.writeInt(this.flags);
            dos.writeByte(this.pulseShape);
            dos.writeByte((byte)this.padding1);
            dos.writeInt((int)this.padding2);
            dos.writeShort((short)this.padding3);
            dos.writeShort((short)this.dERecords.size());
            for (int idx = 0; idx < this.dERecords.size(); ++idx) {
                StandardVariableSpecification aStandardVariableSpecification = this.dERecords.get(idx);
                aStandardVariableSpecification.marshal(dos);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            this.munitionType.unmarshal(dis);
            this.shotStartTime.unmarshal(dis);
            this.commulativeShotTime = dis.readFloat();
            this.ApertureEmitterLocation.unmarshal(dis);
            this.apertureDiameter = dis.readFloat();
            this.wavelength = dis.readFloat();
            this.peakIrradiance = dis.readFloat();
            this.pulseRepetitionFrequency = dis.readFloat();
            this.pulseWidth = dis.readInt();
            this.flags = dis.readInt();
            this.pulseShape = dis.readByte();
            this.padding1 = (short)dis.readUnsignedByte();
            this.padding2 = dis.readInt();
            this.padding3 = dis.readUnsignedShort();
            this.numberOfDERecords = dis.readUnsignedShort();
            for (int idx = 0; idx < this.numberOfDERecords; ++idx) {
                StandardVariableSpecification anX = new StandardVariableSpecification();
                anX.unmarshal(dis);
                this.dERecords.add(anX);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.munitionType.marshal(buff);
        this.shotStartTime.marshal(buff);
        buff.putFloat(this.commulativeShotTime);
        this.ApertureEmitterLocation.marshal(buff);
        buff.putFloat(this.apertureDiameter);
        buff.putFloat(this.wavelength);
        buff.putFloat(this.peakIrradiance);
        buff.putFloat(this.pulseRepetitionFrequency);
        buff.putInt(this.pulseWidth);
        buff.putInt(this.flags);
        buff.put(this.pulseShape);
        buff.put((byte)this.padding1);
        buff.putInt((int)this.padding2);
        buff.putShort((short)this.padding3);
        buff.putShort((short)this.dERecords.size());
        for (int idx = 0; idx < this.dERecords.size(); ++idx) {
            StandardVariableSpecification aStandardVariableSpecification = this.dERecords.get(idx);
            aStandardVariableSpecification.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.munitionType.unmarshal(buff);
        this.shotStartTime.unmarshal(buff);
        this.commulativeShotTime = buff.getFloat();
        this.ApertureEmitterLocation.unmarshal(buff);
        this.apertureDiameter = buff.getFloat();
        this.wavelength = buff.getFloat();
        this.peakIrradiance = buff.getFloat();
        this.pulseRepetitionFrequency = buff.getFloat();
        this.pulseWidth = buff.getInt();
        this.flags = buff.getInt();
        this.pulseShape = buff.get();
        this.padding1 = (short)(buff.get() & 0xFF);
        this.padding2 = buff.getInt();
        this.padding3 = buff.getShort() & 0xFFFF;
        this.numberOfDERecords = buff.getShort() & 0xFFFF;
        for (int idx = 0; idx < this.numberOfDERecords; ++idx) {
            StandardVariableSpecification anX = new StandardVariableSpecification();
            anX.unmarshal(buff);
            this.dERecords.add(anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof DirectedEnergyFirePdu)) {
            return false;
        }
        DirectedEnergyFirePdu rhs = (DirectedEnergyFirePdu)obj;
        if (!this.munitionType.equals(rhs.munitionType)) {
            ivarsEqual = false;
        }
        if (!this.shotStartTime.equals(rhs.shotStartTime)) {
            ivarsEqual = false;
        }
        if (this.commulativeShotTime != rhs.commulativeShotTime) {
            ivarsEqual = false;
        }
        if (!this.ApertureEmitterLocation.equals(rhs.ApertureEmitterLocation)) {
            ivarsEqual = false;
        }
        if (this.apertureDiameter != rhs.apertureDiameter) {
            ivarsEqual = false;
        }
        if (this.wavelength != rhs.wavelength) {
            ivarsEqual = false;
        }
        if (this.peakIrradiance != rhs.peakIrradiance) {
            ivarsEqual = false;
        }
        if (this.pulseRepetitionFrequency != rhs.pulseRepetitionFrequency) {
            ivarsEqual = false;
        }
        if (this.pulseWidth != rhs.pulseWidth) {
            ivarsEqual = false;
        }
        if (this.flags != rhs.flags) {
            ivarsEqual = false;
        }
        if (this.pulseShape != rhs.pulseShape) {
            ivarsEqual = false;
        }
        if (this.padding1 != rhs.padding1) {
            ivarsEqual = false;
        }
        if (this.padding2 != rhs.padding2) {
            ivarsEqual = false;
        }
        if (this.padding3 != rhs.padding3) {
            ivarsEqual = false;
        }
        if (this.numberOfDERecords != rhs.numberOfDERecords) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.dERecords.size(); ++idx) {
            if (this.dERecords.get(idx).equals(rhs.dERecords.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

