/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.EntityID;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class DirectedEnergyTargetEnergyDeposition
implements Serializable {
    protected EntityID targetEntityID = new EntityID();
    protected int padding = 0;
    protected float peakIrradiance;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += this.targetEntityID.getMarshalledSize();
        marshalSize += 2;
        return marshalSize += 4;
    }

    public void setTargetEntityID(EntityID pTargetEntityID) {
        this.targetEntityID = pTargetEntityID;
    }

    public EntityID getTargetEntityID() {
        return this.targetEntityID;
    }

    public void setPadding(int pPadding) {
        this.padding = pPadding;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPeakIrradiance(float pPeakIrradiance) {
        this.peakIrradiance = pPeakIrradiance;
    }

    public float getPeakIrradiance() {
        return this.peakIrradiance;
    }

    public void marshal(DataOutputStream dos) {
        try {
            this.targetEntityID.marshal(dos);
            dos.writeShort((short)this.padding);
            dos.writeFloat(this.peakIrradiance);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.targetEntityID.unmarshal(dis);
            this.padding = dis.readUnsignedShort();
            this.peakIrradiance = dis.readFloat();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        this.targetEntityID.marshal(buff);
        buff.putShort((short)this.padding);
        buff.putFloat(this.peakIrradiance);
    }

    public void unmarshal(ByteBuffer buff) {
        this.targetEntityID.unmarshal(buff);
        this.padding = buff.getShort() & 0xFFFF;
        this.peakIrradiance = buff.getFloat();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof DirectedEnergyTargetEnergyDeposition)) {
            return false;
        }
        DirectedEnergyTargetEnergyDeposition rhs = (DirectedEnergyTargetEnergyDeposition)obj;
        if (!this.targetEntityID.equals(rhs.targetEntityID)) {
            ivarsEqual = false;
        }
        if (this.padding != rhs.padding) {
            ivarsEqual = false;
        }
        if (this.peakIrradiance != rhs.peakIrradiance) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

