/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.DistributedEmissionsFamilyPdu;
import edu.nps.moves.dis7.ElectronicEmissionSystemData;
import edu.nps.moves.dis7.EntityID;
import edu.nps.moves.dis7.EventIdentifier;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ElectronicEmissionsPdu
extends DistributedEmissionsFamilyPdu
implements Serializable {
    protected EntityID emittingEntityID = new EntityID();
    protected EventIdentifier eventID = new EventIdentifier();
    protected short stateUpdateIndicator;
    protected short numberOfSystems;
    protected int paddingForEmissionsPdu;
    protected List<ElectronicEmissionSystemData> systems = new ArrayList<ElectronicEmissionSystemData>();

    public ElectronicEmissionsPdu() {
        this.setPduType((short)23);
        this.setPaddingForEmissionsPdu(0);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.emittingEntityID.getMarshalledSize();
        marshalSize += this.eventID.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        marshalSize += 2;
        ++marshalSize;
        ++marshalSize;
        marshalSize += 2;
        for (int idx = 0; idx < this.systems.size(); ++idx) {
            ElectronicEmissionSystemData listElement = this.systems.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public EntityID getEmittingEntityID() {
        return this.emittingEntityID;
    }

    public void setEmittingEntityID(EntityID pEmittingEntityID) {
        this.emittingEntityID = pEmittingEntityID;
    }

    public EventIdentifier getEventID() {
        return this.eventID;
    }

    public void setEventID(EventIdentifier pEventID) {
        this.eventID = pEventID;
    }

    public short getStateUpdateIndicator() {
        return this.stateUpdateIndicator;
    }

    public void setStateUpdateIndicator(short pStateUpdateIndicator) {
        this.stateUpdateIndicator = pStateUpdateIndicator;
    }

    public short getNumberOfSystems() {
        return this.numberOfSystems;
    }

    public void setNumberOfSystems(short pNumberOfSystems) {
        this.numberOfSystems = pNumberOfSystems;
    }

    public int getPaddingForEmissionsPdu() {
        return this.paddingForEmissionsPdu;
    }

    public void setPaddingForEmissionsPdu(int pPaddingForEmissionsPdu) {
        this.paddingForEmissionsPdu = pPaddingForEmissionsPdu;
    }

    public List<ElectronicEmissionSystemData> getSystems() {
        return this.systems;
    }

    public void setSystems(List<ElectronicEmissionSystemData> systems) {
        this.systems = systems;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            this.emittingEntityID.marshal(dos);
            this.eventID.marshal(dos);
            dos.writeByte((byte)this.stateUpdateIndicator);
            dos.writeByte((byte)this.systems.size());
            dos.writeShort((short)this.paddingForEmissionsPdu);
            for (int idx = 0; idx < this.systems.size(); ++idx) {
                ElectronicEmissionSystemData aElectronicEmissionSystemData = this.systems.get(idx);
                aElectronicEmissionSystemData.marshal(dos);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            this.emittingEntityID.unmarshal(dis);
            this.eventID.unmarshal(dis);
            this.stateUpdateIndicator = (short)dis.readUnsignedByte();
            this.numberOfSystems = (short)dis.readUnsignedByte();
            this.paddingForEmissionsPdu = dis.readUnsignedShort();
            for (int idx = 0; idx < this.numberOfSystems; ++idx) {
                ElectronicEmissionSystemData anX = new ElectronicEmissionSystemData();
                anX.unmarshal(dis);
                this.systems.add(anX);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.emittingEntityID.marshal(buff);
        this.eventID.marshal(buff);
        buff.put((byte)this.stateUpdateIndicator);
        buff.put((byte)this.systems.size());
        buff.putShort((short)this.paddingForEmissionsPdu);
        for (int idx = 0; idx < this.systems.size(); ++idx) {
            ElectronicEmissionSystemData aElectronicEmissionSystemData = this.systems.get(idx);
            aElectronicEmissionSystemData.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.emittingEntityID.unmarshal(buff);
        this.eventID.unmarshal(buff);
        this.stateUpdateIndicator = (short)(buff.get() & 0xFF);
        this.numberOfSystems = (short)(buff.get() & 0xFF);
        this.paddingForEmissionsPdu = buff.getShort() & 0xFFFF;
        for (int idx = 0; idx < this.numberOfSystems; ++idx) {
            ElectronicEmissionSystemData anX = new ElectronicEmissionSystemData();
            anX.unmarshal(buff);
            this.systems.add(anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof ElectronicEmissionsPdu)) {
            return false;
        }
        ElectronicEmissionsPdu rhs = (ElectronicEmissionsPdu)obj;
        if (!this.emittingEntityID.equals(rhs.emittingEntityID)) {
            ivarsEqual = false;
        }
        if (!this.eventID.equals(rhs.eventID)) {
            ivarsEqual = false;
        }
        if (this.stateUpdateIndicator != rhs.stateUpdateIndicator) {
            ivarsEqual = false;
        }
        if (this.numberOfSystems != rhs.numberOfSystems) {
            ivarsEqual = false;
        }
        if (this.paddingForEmissionsPdu != rhs.paddingForEmissionsPdu) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.systems.size(); ++idx) {
            if (this.systems.get(idx).equals(rhs.systems.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

