/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Objects;

public class EntityID
implements Serializable {
    protected int siteID;
    protected int applicationID;
    protected int entityID;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 2;
        marshalSize += 2;
        return marshalSize += 2;
    }

    public void setSiteID(int pSiteID) {
        this.siteID = pSiteID;
    }

    public int getSiteID() {
        return this.siteID;
    }

    public void setApplicationID(int pApplicationID) {
        this.applicationID = pApplicationID;
    }

    public int getApplicationID() {
        return this.applicationID;
    }

    public void setEntityID(int pEntityID) {
        this.entityID = pEntityID;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeShort((short)this.siteID);
            dos.writeShort((short)this.applicationID);
            dos.writeShort((short)this.entityID);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.siteID = dis.readUnsignedShort();
            this.applicationID = dis.readUnsignedShort();
            this.entityID = dis.readUnsignedShort();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.putShort((short)this.siteID);
        buff.putShort((short)this.applicationID);
        buff.putShort((short)this.entityID);
    }

    public void unmarshal(ByteBuffer buff) {
        this.siteID = buff.getShort() & 0xFFFF;
        this.applicationID = buff.getShort() & 0xFFFF;
        this.entityID = buff.getShort() & 0xFFFF;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof EntityID)) {
            return false;
        }
        EntityID rhs = (EntityID)obj;
        if (this.siteID != rhs.siteID) {
            ivarsEqual = false;
        }
        if (this.applicationID != rhs.applicationID) {
            ivarsEqual = false;
        }
        if (this.entityID != rhs.entityID) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }

    public int hashCode() {
        return Objects.hash(this.siteID, this.applicationID, this.entityID);
    }
}

