/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.ArticulatedParts;
import edu.nps.moves.dis7.AttachedParts;
import edu.nps.moves.dis7.EntityAssociation;
import edu.nps.moves.dis7.EntityID;
import edu.nps.moves.dis7.EntityInformationFamilyPdu;
import edu.nps.moves.dis7.EntityTypeVP;
import edu.nps.moves.dis7.EulerAngles;
import edu.nps.moves.dis7.SeparationVP;
import edu.nps.moves.dis7.VariableParameter;
import edu.nps.moves.dis7.Vector3Double;
import edu.nps.moves.dis7.Vector3Float;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class EntityStateUpdatePdu
extends EntityInformationFamilyPdu
implements Serializable {
    protected EntityID entityID = new EntityID();
    protected byte padding1;
    protected short numberOfVariableParameters;
    protected Vector3Float entityLinearVelocity = new Vector3Float();
    protected Vector3Double entityLocation = new Vector3Double();
    protected EulerAngles entityOrientation = new EulerAngles();
    protected long entityAppearance;
    protected List<VariableParameter> variableParameters = new ArrayList<VariableParameter>();

    public EntityStateUpdatePdu() {
        this.setPduType((short)67);
        this.setProtocolFamily((short)1);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.entityID.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        marshalSize += this.entityLinearVelocity.getMarshalledSize();
        marshalSize += this.entityLocation.getMarshalledSize();
        marshalSize += this.entityOrientation.getMarshalledSize();
        marshalSize += 4;
        block7: for (int idx = 0; idx < this.variableParameters.size(); ++idx) {
            VariableParameter listElement = this.variableParameters.get(idx);
            switch (listElement.recordType) {
                case 0: {
                    marshalSize += ((ArticulatedParts)listElement).getMarshalledSize();
                    continue block7;
                }
                case 1: {
                    marshalSize += ((AttachedParts)listElement).getMarshalledSize();
                    continue block7;
                }
                case 2: {
                    marshalSize += ((SeparationVP)listElement).getMarshalledSize();
                    continue block7;
                }
                case 3: {
                    marshalSize += ((EntityTypeVP)listElement).getMarshalledSize();
                    continue block7;
                }
                case 4: {
                    marshalSize += ((EntityAssociation)listElement).getMarshalledSize();
                }
            }
        }
        return marshalSize;
    }

    public void setEntityID(EntityID pEntityID) {
        this.entityID = pEntityID;
    }

    public EntityID getEntityID() {
        return this.entityID;
    }

    public void setPadding1(byte pPadding1) {
        this.padding1 = pPadding1;
    }

    public byte getPadding1() {
        return this.padding1;
    }

    public short getNumberOfVariableParameters() {
        return (short)this.variableParameters.size();
    }

    public void setNumberOfVariableParameters(short pNumberOfVariableParameters) {
        this.numberOfVariableParameters = pNumberOfVariableParameters;
    }

    public void setEntityLinearVelocity(Vector3Float pEntityLinearVelocity) {
        this.entityLinearVelocity = pEntityLinearVelocity;
    }

    public Vector3Float getEntityLinearVelocity() {
        return this.entityLinearVelocity;
    }

    public void setEntityLocation(Vector3Double pEntityLocation) {
        this.entityLocation = pEntityLocation;
    }

    public Vector3Double getEntityLocation() {
        return this.entityLocation;
    }

    public void setEntityOrientation(EulerAngles pEntityOrientation) {
        this.entityOrientation = pEntityOrientation;
    }

    public EulerAngles getEntityOrientation() {
        return this.entityOrientation;
    }

    public void setEntityAppearance(long pEntityAppearance) {
        this.entityAppearance = pEntityAppearance;
    }

    public long getEntityAppearance() {
        return this.entityAppearance;
    }

    public void setVariableParameters(List<VariableParameter> pVariableParameters) {
        this.variableParameters = pVariableParameters;
    }

    public List<VariableParameter> getVariableParameters() {
        return this.variableParameters;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            this.entityID.marshal(dos);
            dos.writeByte(this.padding1);
            dos.writeByte((byte)this.variableParameters.size());
            this.entityLinearVelocity.marshal(dos);
            this.entityLocation.marshal(dos);
            this.entityOrientation.marshal(dos);
            dos.writeInt((int)this.entityAppearance);
            block9: for (int idx = 0; idx < this.variableParameters.size(); ++idx) {
                VariableParameter aVariableParameter = this.variableParameters.get(idx);
                switch (aVariableParameter.recordType) {
                    case 0: {
                        ((ArticulatedParts)aVariableParameter).marshal(dos);
                        continue block9;
                    }
                    case 1: {
                        ((AttachedParts)aVariableParameter).marshal(dos);
                        continue block9;
                    }
                    case 2: {
                        ((SeparationVP)aVariableParameter).marshal(dos);
                        continue block9;
                    }
                    case 3: {
                        ((EntityTypeVP)aVariableParameter).marshal(dos);
                        continue block9;
                    }
                    case 4: {
                        ((EntityAssociation)aVariableParameter).marshal(dos);
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            this.entityID.unmarshal(dis);
            this.padding1 = dis.readByte();
            this.numberOfVariableParameters = (short)dis.readUnsignedByte();
            this.entityLinearVelocity.unmarshal(dis);
            this.entityLocation.unmarshal(dis);
            this.entityOrientation.unmarshal(dis);
            this.entityAppearance = dis.readInt();
            for (int idx = 0; idx < this.numberOfVariableParameters; ++idx) {
                VariableParameter anX = new VariableParameter();
                anX.unmarshal(dis);
                switch (anX.getRecordType()) {
                    case 0: {
                        anX = new ArticulatedParts();
                        ((ArticulatedParts)anX).unmarshal(dis);
                        break;
                    }
                    case 1: {
                        anX = new AttachedParts();
                        ((AttachedParts)anX).unmarshal(dis);
                        break;
                    }
                    case 2: {
                        anX = new SeparationVP();
                        ((SeparationVP)anX).unmarshal(dis);
                        break;
                    }
                    case 3: {
                        anX = new EntityTypeVP();
                        ((EntityTypeVP)anX).unmarshal(dis);
                        break;
                    }
                    case 4: {
                        anX = new EntityAssociation();
                        ((EntityAssociation)anX).unmarshal(dis);
                    }
                }
                this.variableParameters.add(anX);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.entityID.marshal(buff);
        buff.put(this.padding1);
        buff.put((byte)this.variableParameters.size());
        this.entityLinearVelocity.marshal(buff);
        this.entityLocation.marshal(buff);
        this.entityOrientation.marshal(buff);
        buff.putInt((int)this.entityAppearance);
        block7: for (int idx = 0; idx < this.variableParameters.size(); ++idx) {
            VariableParameter aVariableParameter = this.variableParameters.get(idx);
            switch (aVariableParameter.getRecordType()) {
                case 0: {
                    ((ArticulatedParts)aVariableParameter).marshal(buff);
                    continue block7;
                }
                case 1: {
                    ((AttachedParts)aVariableParameter).marshal(buff);
                    continue block7;
                }
                case 2: {
                    ((SeparationVP)aVariableParameter).marshal(buff);
                    continue block7;
                }
                case 3: {
                    ((EntityTypeVP)aVariableParameter).marshal(buff);
                    continue block7;
                }
                case 4: {
                    ((EntityAssociation)aVariableParameter).marshal(buff);
                }
            }
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.entityID.unmarshal(buff);
        this.padding1 = buff.get();
        this.numberOfVariableParameters = (short)(buff.get() & 0xFF);
        this.entityLinearVelocity.unmarshal(buff);
        this.entityLocation.unmarshal(buff);
        this.entityOrientation.unmarshal(buff);
        this.entityAppearance = buff.getInt();
        for (int idx = 0; idx < this.numberOfVariableParameters; ++idx) {
            VariableParameter anX = new VariableParameter();
            anX.unmarshal(buff);
            switch (anX.getRecordType()) {
                case 0: {
                    anX = new ArticulatedParts();
                    ((ArticulatedParts)anX).unmarshal(buff);
                    break;
                }
                case 1: {
                    anX = new AttachedParts();
                    ((AttachedParts)anX).unmarshal(buff);
                    break;
                }
                case 2: {
                    anX = new SeparationVP();
                    ((SeparationVP)anX).unmarshal(buff);
                    break;
                }
                case 3: {
                    anX = new EntityTypeVP();
                    ((EntityTypeVP)anX).unmarshal(buff);
                    break;
                }
                case 4: {
                    anX = new EntityAssociation();
                    ((EntityAssociation)anX).unmarshal(buff);
                }
            }
            this.variableParameters.add(anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof EntityStateUpdatePdu)) {
            return false;
        }
        EntityStateUpdatePdu rhs = (EntityStateUpdatePdu)obj;
        if (!this.entityID.equals(rhs.entityID)) {
            ivarsEqual = false;
        }
        if (this.padding1 != rhs.padding1) {
            ivarsEqual = false;
        }
        if (this.numberOfVariableParameters != rhs.numberOfVariableParameters) {
            ivarsEqual = false;
        }
        if (!this.entityLinearVelocity.equals(rhs.entityLinearVelocity)) {
            ivarsEqual = false;
        }
        if (!this.entityLocation.equals(rhs.entityLocation)) {
            ivarsEqual = false;
        }
        if (!this.entityOrientation.equals(rhs.entityOrientation)) {
            ivarsEqual = false;
        }
        if (this.entityAppearance != rhs.entityAppearance) {
            ivarsEqual = false;
        }
        block7: for (int idx = 0; idx < this.variableParameters.size(); ++idx) {
            if (this.variableParameters.get(idx).getRecordType() != rhs.variableParameters.get(idx).getRecordType()) {
                ivarsEqual = false;
                continue;
            }
            switch (this.variableParameters.get(idx).getRecordType()) {
                case 0: {
                    if (((ArticulatedParts)this.variableParameters.get(idx)).equalsImpl((ArticulatedParts)rhs.variableParameters.get(idx))) continue block7;
                    ivarsEqual = false;
                    continue block7;
                }
                case 1: {
                    if (((AttachedParts)this.variableParameters.get(idx)).equalsImpl((AttachedParts)rhs.variableParameters.get(idx))) continue block7;
                    ivarsEqual = false;
                    continue block7;
                }
                case 2: {
                    if (((SeparationVP)this.variableParameters.get(idx)).equalsImpl((AttachedParts)rhs.variableParameters.get(idx))) continue block7;
                    ivarsEqual = false;
                    continue block7;
                }
                case 3: {
                    if (((EntityTypeVP)this.variableParameters.get(idx)).equalsImpl((EntityTypeVP)rhs.variableParameters.get(idx))) continue block7;
                    ivarsEqual = false;
                    continue block7;
                }
                case 4: {
                    if (((EntityAssociation)this.variableParameters.get(idx)).equalsImpl((EntityAssociation)rhs.variableParameters.get(idx))) continue block7;
                    ivarsEqual = false;
                }
            }
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

