/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class Environment
implements Serializable {
    protected long environmentType;
    protected int length;
    protected short index;
    protected short padding = 0;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 4;
        marshalSize += 2;
        ++marshalSize;
        return ++marshalSize;
    }

    public void setEnvironmentType(long pEnvironmentType) {
        this.environmentType = pEnvironmentType;
    }

    public long getEnvironmentType() {
        return this.environmentType;
    }

    public void setLength(int pLength) {
        this.length = pLength;
    }

    public int getLength() {
        return this.length;
    }

    public void setIndex(short pIndex) {
        this.index = pIndex;
    }

    public short getIndex() {
        return this.index;
    }

    public void setPadding(short pPadding) {
        this.padding = pPadding;
    }

    public short getPadding() {
        return this.padding;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeInt((int)this.environmentType);
            dos.writeShort((short)this.length);
            dos.writeByte((byte)this.index);
            dos.writeByte((byte)this.padding);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.environmentType = dis.readInt();
            this.length = dis.readUnsignedShort();
            this.index = (short)dis.readUnsignedByte();
            this.padding = (short)dis.readUnsignedByte();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.putInt((int)this.environmentType);
        buff.putShort((short)this.length);
        buff.put((byte)this.index);
        buff.put((byte)this.padding);
    }

    public void unmarshal(ByteBuffer buff) {
        this.environmentType = buff.getInt();
        this.length = buff.getShort() & 0xFFFF;
        this.index = (short)(buff.get() & 0xFF);
        this.padding = (short)(buff.get() & 0xFF);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof Environment)) {
            return false;
        }
        Environment rhs = (Environment)obj;
        if (this.environmentType != rhs.environmentType) {
            ivarsEqual = false;
        }
        if (this.length != rhs.length) {
            ivarsEqual = false;
        }
        if (this.index != rhs.index) {
            ivarsEqual = false;
        }
        if (this.padding != rhs.padding) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

