/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.Descriptor;
import edu.nps.moves.dis7.EntityType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;

public class ExplosionDescriptor
extends Descriptor {
    protected EntityType explodingObject = new EntityType();
    protected int explosiveMaterial;
    protected int padding = 0;
    protected float explosiveForce;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += this.explodingObject.getMarshalledSize();
        marshalSize += 2;
        marshalSize += 2;
        return marshalSize += 4;
    }

    public void setExplodingObject(EntityType pExplodingObject) {
        this.explodingObject = pExplodingObject;
    }

    public EntityType getExplodingObject() {
        return this.explodingObject;
    }

    public void setExplosiveMaterial(int pExplosiveMaterial) {
        this.explosiveMaterial = pExplosiveMaterial;
    }

    public int getExplosiveMaterial() {
        return this.explosiveMaterial;
    }

    public void setPadding(int pPadding) {
        this.padding = pPadding;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setExplosiveForce(float pExplosiveForce) {
        this.explosiveForce = pExplosiveForce;
    }

    public float getExplosiveForce() {
        return this.explosiveForce;
    }

    public void marshal(DataOutputStream dos) {
        try {
            this.explodingObject.marshal(dos);
            dos.writeShort((short)this.explosiveMaterial);
            dos.writeShort((short)this.padding);
            dos.writeFloat(this.explosiveForce);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.explodingObject.unmarshal(dis);
            this.explosiveMaterial = dis.readUnsignedShort();
            this.padding = dis.readUnsignedShort();
            this.explosiveForce = dis.readFloat();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        this.explodingObject.marshal(buff);
        buff.putShort((short)this.explosiveMaterial);
        buff.putShort((short)this.padding);
        buff.putFloat(this.explosiveForce);
    }

    public void unmarshal(ByteBuffer buff) {
        this.explodingObject.unmarshal(buff);
        this.explosiveMaterial = buff.getShort() & 0xFFFF;
        this.padding = buff.getShort() & 0xFFFF;
        this.explosiveForce = buff.getFloat();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof ExplosionDescriptor)) {
            return false;
        }
        ExplosionDescriptor rhs = (ExplosionDescriptor)obj;
        if (!this.explodingObject.equals(rhs.explodingObject)) {
            ivarsEqual = false;
        }
        if (this.explosiveMaterial != rhs.explosiveMaterial) {
            ivarsEqual = false;
        }
        if (this.padding != rhs.padding) {
            ivarsEqual = false;
        }
        if (this.explosiveForce != rhs.explosiveForce) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

