/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.Descriptor;
import edu.nps.moves.dis7.EntityID;
import edu.nps.moves.dis7.EventIdentifier;
import edu.nps.moves.dis7.ExpendableDescriptor;
import edu.nps.moves.dis7.MunitionDescriptor;
import edu.nps.moves.dis7.Vector3Double;
import edu.nps.moves.dis7.Vector3Float;
import edu.nps.moves.dis7.WarfareFamilyPdu;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class FirePdu
extends WarfareFamilyPdu
implements Serializable {
    protected EntityID munitionExpendibleID = new EntityID();
    protected EventIdentifier eventID = new EventIdentifier();
    protected long fireMissionIndex;
    protected Vector3Double locationInWorldCoordinates = new Vector3Double();
    protected Descriptor descriptor = new MunitionDescriptor();
    protected Vector3Float velocity = new Vector3Float();
    protected float range;

    public FirePdu() {
        this.setPduType((short)2);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.munitionExpendibleID.getMarshalledSize();
        marshalSize += this.eventID.getMarshalledSize();
        marshalSize += 4;
        marshalSize += this.locationInWorldCoordinates.getMarshalledSize();
        int fireTypeIndicator = this.getFireTypeIndicator();
        marshalSize = fireTypeIndicator == 0 ? (marshalSize += ((MunitionDescriptor)this.descriptor).getMarshalledSize()) : (marshalSize += ((ExpendableDescriptor)this.descriptor).getMarshalledSize());
        marshalSize += this.velocity.getMarshalledSize();
        return marshalSize += 4;
    }

    public void setMunitionExpendibleID(EntityID pMunitionExpendibleID) {
        this.munitionExpendibleID = pMunitionExpendibleID;
    }

    public EntityID getMunitionExpendibleID() {
        return this.munitionExpendibleID;
    }

    public void setEventID(EventIdentifier pEventID) {
        this.eventID = pEventID;
    }

    public EventIdentifier getEventID() {
        return this.eventID;
    }

    public void setFireMissionIndex(long pFireMissionIndex) {
        this.fireMissionIndex = pFireMissionIndex;
    }

    public long getFireMissionIndex() {
        return this.fireMissionIndex;
    }

    public void setLocationInWorldCoordinates(Vector3Double pLocationInWorldCoordinates) {
        this.locationInWorldCoordinates = pLocationInWorldCoordinates;
    }

    public Vector3Double getLocationInWorldCoordinates() {
        return this.locationInWorldCoordinates;
    }

    public void setDescriptor(Descriptor pDescriptor) {
        this.descriptor = pDescriptor;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setVelocity(Vector3Float pVelocity) {
        this.velocity = pVelocity;
    }

    public Vector3Float getVelocity() {
        return this.velocity;
    }

    public void setRange(float pRange) {
        this.range = pRange;
    }

    public float getRange() {
        return this.range;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            this.munitionExpendibleID.marshal(dos);
            this.eventID.marshal(dos);
            dos.writeInt((int)this.fireMissionIndex);
            this.locationInWorldCoordinates.marshal(dos);
            int fireTypeIndicator = this.getFireTypeIndicator();
            if (fireTypeIndicator == 0) {
                ((MunitionDescriptor)this.descriptor).marshal(dos);
            } else {
                ((ExpendableDescriptor)this.descriptor).marshal(dos);
            }
            this.velocity.marshal(dos);
            dos.writeFloat(this.range);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            this.munitionExpendibleID.unmarshal(dis);
            this.eventID.unmarshal(dis);
            this.fireMissionIndex = dis.readInt();
            this.locationInWorldCoordinates.unmarshal(dis);
            int fireTypeIndicator = this.getFireTypeIndicator();
            if (fireTypeIndicator == 0) {
                this.descriptor = new MunitionDescriptor();
                ((MunitionDescriptor)this.descriptor).unmarshal(dis);
            } else {
                this.descriptor = new ExpendableDescriptor();
                ((ExpendableDescriptor)this.descriptor).unmarshal(dis);
            }
            this.velocity.unmarshal(dis);
            this.range = dis.readFloat();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.munitionExpendibleID.marshal(buff);
        this.eventID.marshal(buff);
        buff.putInt((int)this.fireMissionIndex);
        this.locationInWorldCoordinates.marshal(buff);
        int fireTypeIndicator = this.getFireTypeIndicator();
        if (fireTypeIndicator == 0) {
            ((MunitionDescriptor)this.descriptor).marshal(buff);
        } else {
            ((ExpendableDescriptor)this.descriptor).marshal(buff);
        }
        this.velocity.marshal(buff);
        buff.putFloat(this.range);
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.munitionExpendibleID.unmarshal(buff);
        this.eventID.unmarshal(buff);
        this.fireMissionIndex = buff.getInt();
        this.locationInWorldCoordinates.unmarshal(buff);
        int fireTypeIndicator = this.getFireTypeIndicator();
        if (fireTypeIndicator == 0) {
            this.descriptor = new MunitionDescriptor();
            ((MunitionDescriptor)this.descriptor).unmarshal(buff);
        } else {
            this.descriptor = new ExpendableDescriptor();
            ((ExpendableDescriptor)this.descriptor).unmarshal(buff);
        }
        this.velocity.unmarshal(buff);
        this.range = buff.getFloat();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof FirePdu)) {
            return false;
        }
        FirePdu rhs = (FirePdu)obj;
        if (!this.munitionExpendibleID.equals(rhs.munitionExpendibleID)) {
            ivarsEqual = false;
        }
        if (!this.eventID.equals(rhs.eventID)) {
            ivarsEqual = false;
        }
        if (this.fireMissionIndex != rhs.fireMissionIndex) {
            ivarsEqual = false;
        }
        if (!this.locationInWorldCoordinates.equals(rhs.locationInWorldCoordinates)) {
            ivarsEqual = false;
        }
        if (!this.descriptor.equals(rhs.descriptor)) {
            ivarsEqual = false;
        }
        if (!this.velocity.equals(rhs.velocity)) {
            ivarsEqual = false;
        }
        if (this.range != rhs.range) {
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }

    private int getFireTypeIndicator() {
        return (this.pduStatus & 0x10) >> 4;
    }
}

