/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class GridAxis
implements Serializable {
    protected double domainInitialXi;
    protected double domainFinalXi;
    protected int domainPointsXi;
    protected short interleafFactor;
    protected short axisType;
    protected int numberOfPointsOnXiAxis;
    protected int initialIndex;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 8;
        marshalSize += 8;
        marshalSize += 2;
        ++marshalSize;
        ++marshalSize;
        marshalSize += 2;
        return marshalSize += 2;
    }

    public void setDomainInitialXi(double pDomainInitialXi) {
        this.domainInitialXi = pDomainInitialXi;
    }

    public double getDomainInitialXi() {
        return this.domainInitialXi;
    }

    public void setDomainFinalXi(double pDomainFinalXi) {
        this.domainFinalXi = pDomainFinalXi;
    }

    public double getDomainFinalXi() {
        return this.domainFinalXi;
    }

    public void setDomainPointsXi(int pDomainPointsXi) {
        this.domainPointsXi = pDomainPointsXi;
    }

    public int getDomainPointsXi() {
        return this.domainPointsXi;
    }

    public void setInterleafFactor(short pInterleafFactor) {
        this.interleafFactor = pInterleafFactor;
    }

    public short getInterleafFactor() {
        return this.interleafFactor;
    }

    public void setAxisType(short pAxisType) {
        this.axisType = pAxisType;
    }

    public short getAxisType() {
        return this.axisType;
    }

    public void setNumberOfPointsOnXiAxis(int pNumberOfPointsOnXiAxis) {
        this.numberOfPointsOnXiAxis = pNumberOfPointsOnXiAxis;
    }

    public int getNumberOfPointsOnXiAxis() {
        return this.numberOfPointsOnXiAxis;
    }

    public void setInitialIndex(int pInitialIndex) {
        this.initialIndex = pInitialIndex;
    }

    public int getInitialIndex() {
        return this.initialIndex;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeDouble(this.domainInitialXi);
            dos.writeDouble(this.domainFinalXi);
            dos.writeShort((short)this.domainPointsXi);
            dos.writeByte((byte)this.interleafFactor);
            dos.writeByte((byte)this.axisType);
            dos.writeShort((short)this.numberOfPointsOnXiAxis);
            dos.writeShort((short)this.initialIndex);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.domainInitialXi = dis.readDouble();
            this.domainFinalXi = dis.readDouble();
            this.domainPointsXi = dis.readUnsignedShort();
            this.interleafFactor = (short)dis.readUnsignedByte();
            this.axisType = (short)dis.readUnsignedByte();
            this.numberOfPointsOnXiAxis = dis.readUnsignedShort();
            this.initialIndex = dis.readUnsignedShort();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.putDouble(this.domainInitialXi);
        buff.putDouble(this.domainFinalXi);
        buff.putShort((short)this.domainPointsXi);
        buff.put((byte)this.interleafFactor);
        buff.put((byte)this.axisType);
        buff.putShort((short)this.numberOfPointsOnXiAxis);
        buff.putShort((short)this.initialIndex);
    }

    public void unmarshal(ByteBuffer buff) {
        this.domainInitialXi = buff.getDouble();
        this.domainFinalXi = buff.getDouble();
        this.domainPointsXi = buff.getShort() & 0xFFFF;
        this.interleafFactor = (short)(buff.get() & 0xFF);
        this.axisType = (short)(buff.get() & 0xFF);
        this.numberOfPointsOnXiAxis = buff.getShort() & 0xFFFF;
        this.initialIndex = buff.getShort() & 0xFFFF;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof GridAxis)) {
            return false;
        }
        GridAxis rhs = (GridAxis)obj;
        if (this.domainInitialXi != rhs.domainInitialXi) {
            ivarsEqual = false;
        }
        if (this.domainFinalXi != rhs.domainFinalXi) {
            ivarsEqual = false;
        }
        if (this.domainPointsXi != rhs.domainPointsXi) {
            ivarsEqual = false;
        }
        if (this.interleafFactor != rhs.interleafFactor) {
            ivarsEqual = false;
        }
        if (this.axisType != rhs.axisType) {
            ivarsEqual = false;
        }
        if (this.numberOfPointsOnXiAxis != rhs.numberOfPointsOnXiAxis) {
            ivarsEqual = false;
        }
        if (this.initialIndex != rhs.initialIndex) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

